/*
 * Decompiled with CFR 0.152.
 */
package org.arquillian.droidium.native_.configuration;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.arquillian.droidium.native_.configuration.DroneConfigurationHolder;
import org.arquillian.droidium.native_.deployment.ExtensionDroneMapper;
import org.arquillian.droidium.native_.spi.event.AfterExtensionDroneMapping;
import org.arquillian.droidium.native_.spi.event.BeforeExtensionDroneMapping;
import org.jboss.arquillian.config.descriptor.api.ArquillianDescriptor;
import org.jboss.arquillian.config.descriptor.api.ExtensionDef;
import org.jboss.arquillian.core.api.Event;
import org.jboss.arquillian.core.api.Instance;
import org.jboss.arquillian.core.api.annotation.Inject;
import org.jboss.arquillian.core.api.annotation.Observes;
import org.jboss.arquillian.drone.spi.DroneConfiguration;
import org.jboss.arquillian.drone.spi.event.AfterDroneConfigured;

public class ExtensionDroneResolver {
    private static final Logger logger = Logger.getLogger(ExtensionDroneResolver.class.getName());
    private static final String DEFAULT_REMOTE_URL = "http://localhost:14444/wd/hub";
    private static final String DEFAULT_PORT = "14444";
    @Inject
    private Instance<ExtensionDroneMapper> extensionDroneMapper;
    @Inject
    private Event<BeforeExtensionDroneMapping> beforeExtensionDroneMappingEvent;
    @Inject
    private Event<AfterExtensionDroneMapping> afterExtensionDroneMappingEvent;

    public void onAfterDroneConfigured(@Observes AfterDroneConfigured event, ArquillianDescriptor descriptor) throws URISyntaxException {
        this.beforeExtensionDroneMappingEvent.fire((Object)new BeforeExtensionDroneMapping());
        logger.log(Level.FINE, "Drone type: {0}\nDrone qualifier: {1}\nDrone configuration name: {2}\n", new Object[]{event.getDroneType(), event.getQualifier().getSimpleName().toLowerCase(), ((DroneConfiguration)event.getConfiguration().asInstance(DroneConfiguration.class)).getConfigurationName().toLowerCase()});
        String configurationName = ((DroneConfiguration)event.getConfiguration().asInstance(DroneConfiguration.class)).getConfigurationName().toLowerCase();
        if (configurationName.equals("drone")) {
            return;
        }
        String qualifier = event.getQualifier().getSimpleName().toLowerCase();
        String configurationNameWithQualifier = configurationName + "-" + qualifier;
        String extensionQualifier = this.resolveExtensionQualifier(descriptor, configurationName, configurationNameWithQualifier);
        ExtensionDef extension = this.getExtension(descriptor, extensionQualifier);
        String browser = this.getBrowser(extension.getExtensionProperties());
        if (browser == null || !browser.equals("android")) {
            logger.info("No \"android\" browser was used. The mapping process to arquillian extension for this Drone is skipped.");
            return;
        }
        String remoteUrl = this.parseRemoteAddress(extension.getExtensionProperties());
        String port = this.parsePort(remoteUrl);
        logger.log(Level.FINE, "Extension name: {0}\nExtension qualifier: {1}\nDrone qualifier: {2}\nPort: {3}", new Object[]{extension.getExtensionName(), extensionQualifier, qualifier, port});
        ((ExtensionDroneMapper)this.extensionDroneMapper.get()).put(extension.getExtensionName(), new DroneConfigurationHolder(extensionQualifier, qualifier, port));
        this.afterExtensionDroneMappingEvent.fire((Object)new AfterExtensionDroneMapping(extension.getExtensionName(), port));
    }

    private String resolveExtensionQualifier(ArquillianDescriptor descriptor, String configurationName, String configurationNameWithQualifier) throws IllegalStateException {
        if (configurationName.equals("webdriver")) {
            for (ExtensionDef extension : descriptor.getExtensions()) {
                if (!extension.getExtensionName().equalsIgnoreCase(configurationNameWithQualifier)) continue;
                return configurationNameWithQualifier;
            }
            for (ExtensionDef extension : descriptor.getExtensions()) {
                if (!extension.getExtensionName().equalsIgnoreCase(configurationName)) continue;
                return configurationName;
            }
            throw new IllegalStateException("Unable to resolve extension qualifier for Drone.");
        }
        throw new IllegalStateException("Please use WebDriver-based Drone and try again.");
    }

    private ExtensionDef getExtension(ArquillianDescriptor descriptor, String extensionQualifier) {
        for (ExtensionDef extension : descriptor.getExtensions()) {
            if (!extension.getExtensionName().equals(extensionQualifier)) continue;
            return extension;
        }
        return null;
    }

    private String getBrowser(Map<String, String> extensionProperties) {
        String browser = extensionProperties.get("browser");
        if (browser == null) {
            browser = extensionProperties.get("browserCapabilities");
        }
        return browser;
    }

    private String parsePort(String remoteUrl) throws URISyntaxException {
        URI uri = new URI(remoteUrl);
        int port = uri.getPort();
        if (port == -1) {
            return DEFAULT_PORT;
        }
        return Integer.toString(port);
    }

    private String parseRemoteAddress(Map<String, String> extensionProperties) {
        String remoteAddress = extensionProperties.get("remoteAddress");
        if (remoteAddress == null) {
            return DEFAULT_REMOTE_URL;
        }
        return remoteAddress;
    }
}

