/*
 * Decompiled with CFR 0.152.
 */
package org.arquillian.droidium.native_.configuration;

import java.io.File;
import org.arquillian.droidium.container.api.ActivityManager;
import org.arquillian.droidium.container.api.AndroidDevice;
import org.arquillian.droidium.container.configuration.AndroidContainerConfiguration;
import org.arquillian.droidium.container.configuration.AndroidSDK;
import org.arquillian.droidium.container.impl.ProcessExecutor;
import org.arquillian.droidium.native_.activity.ActivityWebDriverMapper;
import org.arquillian.droidium.native_.activity.NativeActivityManager;
import org.arquillian.droidium.native_.android.AndroidApplicationHelper;
import org.arquillian.droidium.native_.android.AndroidApplicationManager;
import org.arquillian.droidium.native_.configuration.DroidiumNativeConfiguration;
import org.arquillian.droidium.native_.deployment.ActivityDeploymentMapper;
import org.arquillian.droidium.native_.deployment.AndroidDeploymentRegister;
import org.arquillian.droidium.native_.deployment.DeploymentWebDriverMapper;
import org.arquillian.droidium.native_.deployment.ExtensionDroneMapper;
import org.arquillian.droidium.native_.deployment.SelendroidDeploymentRegister;
import org.arquillian.droidium.native_.instrumentation.DeploymentInstrumentationMapper;
import org.arquillian.droidium.native_.selendroid.SelendroidRebuilder;
import org.arquillian.droidium.native_.selendroid.SelendroidServerManager;
import org.arquillian.droidium.native_.sign.APKSigner;
import org.arquillian.droidium.native_.utils.DroidiumNativeFileUtils;
import org.jboss.arquillian.container.spi.context.annotation.ContainerScoped;
import org.jboss.arquillian.container.spi.event.container.AfterStart;
import org.jboss.arquillian.container.spi.event.container.BeforeStop;
import org.jboss.arquillian.core.api.Instance;
import org.jboss.arquillian.core.api.InstanceProducer;
import org.jboss.arquillian.core.api.annotation.Inject;
import org.jboss.arquillian.core.api.annotation.Observes;
import org.jboss.arquillian.test.spi.annotation.SuiteScoped;

public class DroidiumNativeResourceManager {
    @Inject
    private Instance<AndroidDevice> androidDevice;
    @Inject
    private Instance<AndroidSDK> androidSDK;
    @Inject
    private Instance<ProcessExecutor> processExecutor;
    @Inject
    private Instance<DroidiumNativeConfiguration> droidiumNativeConfiguration;
    @Inject
    @SuiteScoped
    private InstanceProducer<AndroidApplicationHelper> androidApplicationHelper;
    @Inject
    @SuiteScoped
    private InstanceProducer<ActivityDeploymentMapper> activityDeploymentMapper;
    @Inject
    @SuiteScoped
    private InstanceProducer<ActivityWebDriverMapper> activityWebDriverMapper;
    @Inject
    @SuiteScoped
    private InstanceProducer<ExtensionDroneMapper> extensionDroneMapper;
    @Inject
    @SuiteScoped
    private InstanceProducer<DeploymentInstrumentationMapper> deploymentInstrumentationMapper;
    @Inject
    @SuiteScoped
    private InstanceProducer<DeploymentWebDriverMapper> deploymentWebDriverMapper;
    @Inject
    @ContainerScoped
    private InstanceProducer<APKSigner> apkSigner;
    @Inject
    @SuiteScoped
    private InstanceProducer<AndroidApplicationManager> androidApplicationManager;
    @Inject
    @SuiteScoped
    private InstanceProducer<SelendroidServerManager> selendroidServerManager;
    @Inject
    @ContainerScoped
    private InstanceProducer<SelendroidRebuilder> selendroidRebuilder;
    @Inject
    @SuiteScoped
    private InstanceProducer<AndroidDeploymentRegister> androidDeploymentRegister;
    @Inject
    @SuiteScoped
    private InstanceProducer<SelendroidDeploymentRegister> selendroidDeploymentRegister;

    public void onAfterContainerStart(@Observes AfterStart event) {
        if (event.getDeployableContainer().getConfigurationClass() == AndroidContainerConfiguration.class) {
            DroidiumNativeFileUtils.createWorkingDir(((DroidiumNativeConfiguration)this.droidiumNativeConfiguration.get()).getTmpDir());
            this.androidApplicationHelper.set((Object)this.getAndroidApplicationHelper());
            this.activityDeploymentMapper.set((Object)this.getActivityDeploymentMapper());
            this.activityWebDriverMapper.set((Object)this.getActivityWebDriverMapper());
            this.extensionDroneMapper.set((Object)this.getWebDriverPortMapper());
            this.deploymentWebDriverMapper.set((Object)this.getDeploymentWebDriverMapper());
            this.deploymentInstrumentationMapper.set((Object)this.getDeploymentInstrumentationMapper());
            this.apkSigner.set((Object)this.getAPKSigner());
            this.androidApplicationManager.set((Object)this.getAndroidApplicationManager());
            this.selendroidServerManager.set((Object)this.getSelendroidServerManager());
            this.selendroidRebuilder.set((Object)this.getSelendroidRebuilder());
            this.androidDeploymentRegister.set((Object)new AndroidDeploymentRegister());
            this.selendroidDeploymentRegister.set((Object)new SelendroidDeploymentRegister());
            NativeActivityManager activityManager = new NativeActivityManager((ActivityWebDriverMapper)this.activityWebDriverMapper.get());
            ((AndroidDevice)this.androidDevice.get()).getActivityManagerProvider().setActivityManager((ActivityManager)activityManager);
        }
    }

    private DeploymentInstrumentationMapper getDeploymentInstrumentationMapper() {
        DeploymentInstrumentationMapper deploymentInstrumentationMapper = new DeploymentInstrumentationMapper();
        return deploymentInstrumentationMapper;
    }

    public void onDroidiumContainerStop(@Observes BeforeStop event) {
        if (event.getDeployableContainer().getConfigurationClass() == AndroidContainerConfiguration.class && ((DroidiumNativeConfiguration)this.droidiumNativeConfiguration.get()).getRemoveTmpDir()) {
            File dir = DroidiumNativeFileUtils.getTmpDir();
            DroidiumNativeFileUtils.removeWorkingDir(dir);
        }
    }

    private DeploymentWebDriverMapper getDeploymentWebDriverMapper() {
        DeploymentWebDriverMapper deploymentWebDriverMapper = new DeploymentWebDriverMapper();
        return deploymentWebDriverMapper;
    }

    private ActivityWebDriverMapper getActivityWebDriverMapper() {
        ActivityWebDriverMapper activityWebDriverMapper = new ActivityWebDriverMapper();
        return activityWebDriverMapper;
    }

    private ActivityDeploymentMapper getActivityDeploymentMapper() {
        ActivityDeploymentMapper activityDeploymentMapper = new ActivityDeploymentMapper();
        return activityDeploymentMapper;
    }

    private ExtensionDroneMapper getWebDriverPortMapper() {
        ExtensionDroneMapper webDriverPortMapper = new ExtensionDroneMapper();
        return webDriverPortMapper;
    }

    private SelendroidServerManager getSelendroidServerManager() {
        SelendroidServerManager selendroidServerManager = new SelendroidServerManager((AndroidDevice)this.androidDevice.get(), (ProcessExecutor)this.processExecutor.get(), (AndroidSDK)this.androidSDK.get());
        return selendroidServerManager;
    }

    private AndroidApplicationManager getAndroidApplicationManager() {
        AndroidApplicationManager androidApplicationManager = new AndroidApplicationManager((AndroidDevice)this.androidDevice.get(), (ProcessExecutor)this.processExecutor.get(), (AndroidSDK)this.androidSDK.get());
        return androidApplicationManager;
    }

    private APKSigner getAPKSigner() {
        APKSigner signer = new APKSigner((ProcessExecutor)this.processExecutor.get(), (AndroidSDK)this.androidSDK.get(), (DroidiumNativeConfiguration)this.droidiumNativeConfiguration.get());
        return signer;
    }

    private SelendroidRebuilder getSelendroidRebuilder() {
        SelendroidRebuilder selendroidRebuilder = new SelendroidRebuilder((ProcessExecutor)this.processExecutor.get(), (AndroidSDK)this.androidSDK.get());
        return selendroidRebuilder;
    }

    private AndroidApplicationHelper getAndroidApplicationHelper() {
        AndroidApplicationHelper applicationHelper = new AndroidApplicationHelper((ProcessExecutor)this.processExecutor.get(), (AndroidSDK)this.androidSDK.get());
        return applicationHelper;
    }
}

