/*
 * Decompiled with CFR 0.152.
 */
package org.arquillian.droidium.native_.configuration;

import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.arquillian.droidium.container.configuration.Validate;

public class DroidiumNativeConfiguration {
    private String fileSeparator = System.getProperty("file.separator");
    private String logFile = "target" + this.fileSeparator + "android.log";
    private String serverApk = "selendroid-server.apk";
    private String keystore = System.getProperty("user.home") + this.fileSeparator + ".android" + this.fileSeparator + "debug.keystore";
    private String storepass = "android";
    private String keypass = "android";
    private String alias = "androiddebugkey";
    private String sigalg = "SHA1withRSA";
    private String keyalg = "RSA";
    private String removeTmpDir = "true";
    private String tmpDir = System.getProperty("java.io.tmpdir");
    private Map<String, String> properties = new HashMap<String, String>();

    public File getLogFile() {
        return new File(this.getProperty("logFile", this.logFile));
    }

    public File getServerApk() {
        return new File(this.getProperty("serverApk", this.serverApk));
    }

    public File getKeystore() {
        return new File(this.getProperty("keystore", this.keystore));
    }

    public String getStorepass() {
        return this.getProperty("storepass", this.storepass);
    }

    public String getKeypass() {
        return this.getProperty("keypass", this.keypass);
    }

    public String getAlias() {
        return this.getProperty("alias", this.alias);
    }

    public String getSigalg() {
        return this.getProperty("sigalg", this.sigalg);
    }

    public String getKeyalg() {
        return this.getProperty("keyalg", this.keyalg);
    }

    public boolean getRemoveTmpDir() {
        return Boolean.parseBoolean(this.getProperty("removeTmpDir", this.removeTmpDir));
    }

    public File getTmpDir() {
        return new File(this.getProperty("tmpDir", this.tmpDir));
    }

    public void setProperties(Map<String, String> properties) throws IllegalArgumentException {
        Validate.notNull(properties, (String)"Properties to set for Arquillian Droidium native configuration can not be a null object!");
        this.properties = properties;
    }

    public String getProperty(String name, String defaultValue) throws IllegalStateException {
        Validate.notNullOrEmpty((String)name, (String)"unable to get configuration value of null configuration key");
        Validate.notNullOrEmpty((String)defaultValue, (String)("unable to set configuration value of " + name + " to null"));
        String found = this.properties.get(name);
        if (found == null || found.isEmpty()) {
            return defaultValue;
        }
        return found;
    }

    public void setProperty(String property, String value) throws IllegalStateException {
        Validate.notNullOrEmpty((String)property, (String)"unable to set configuration value which key is null");
        Validate.notNullOrEmpty((String)value, (String)"unable to set configuration value which is null");
        this.properties.put(property, value);
    }

    public void validate() throws IllegalArgumentException, IllegalStateException {
        Validate.isReadable((File)this.getServerApk(), (String)("You must provide a valid path to Android Server APK for Arquillian Droidium native plugin. Plese be sure you have read access to the file you entered: " + this.getServerApk()));
        Validate.isReadableDirectory((File)this.getTmpDir(), (String)"Temporary directory you chosed to use for Arquillian Droidium native plugin is not readable. Please be sure you entered a path you have read and write access to.");
        Validate.isWriteable((File)this.getTmpDir(), (String)"Temporary directory you chose to use for Arquillian Droidium native plugin is not writable. Please be sure you entered a path you have read and write access to.");
        try {
            Validate.isReadable((File)this.getKeystore(), (String)("Key store for Android APKs is not readable. File does not exist or you have no read access to this file. In case it does not exist, Arquillian Droidium native plugin tries to create keystore you specified dynamically in the file " + this.getKeystore()));
        }
        catch (IllegalArgumentException ex) {
            // empty catch block
        }
        try {
            this.getLogFile().createNewFile();
        }
        catch (IOException e) {
            throw new IllegalStateException("Unable to create logging file for Arquillian Droidium native plugin at" + this.getLogFile().getAbsolutePath(), e);
        }
        Validate.notNullOrEmpty((String)this.getAlias(), (String)("You must provide valid alias for signing of APK files. You entered '" + this.getAlias() + "'."));
        Validate.notNullOrEmpty((String)this.getKeypass(), (String)("You must provide valid keypass for signing of APK files. You entered '" + this.getKeypass() + "'."));
        Validate.notNullOrEmpty((String)this.getStorepass(), (String)("You must provide valid storepass for signing of APK files. You entered '" + this.getStorepass() + "'."));
        Validate.notNullOrEmpty((String)this.getKeyalg(), (String)("You must provide valid key algorithm for signing packages. You entered '" + this.getKeyalg() + "'."));
        Validate.notNullOrEmpty((String)this.getSigalg(), (String)("You must provide valid key algoritm for signing packages. You entered '" + this.getSigalg() + "'."));
    }
}

