/*
 * Decompiled with CFR 0.152.
 */
package org.arquillian.droidium.native_.android;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.arquillian.droidium.container.configuration.AndroidSDK;
import org.arquillian.droidium.container.configuration.Validate;
import org.arquillian.droidium.container.impl.ProcessExecutor;
import org.arquillian.droidium.native_.utils.Command;

public class AndroidApplicationHelper {
    private static final Logger logger = Logger.getLogger(AndroidApplicationHelper.class.getName());
    private final ProcessExecutor executor;
    private final AndroidSDK sdk;

    public AndroidApplicationHelper(ProcessExecutor executor, AndroidSDK sdk) {
        Validate.notNull((Object)executor, (String)"Process executor to set can not be a null object!");
        Validate.notNull((Object)sdk, (String)"Android SDK to set can not be a null object!");
        this.executor = executor;
        this.sdk = sdk;
    }

    public String getApplicationMainActivity(File apk) {
        try {
            List results = this.executor.execute(this.getAAPTBadgingCommand(apk).getAsArray());
            return this.parseProperty(results, "launchable-activity");
        }
        catch (InterruptedException e) {
            logger.severe("Process to get name of main application activity was interrupted.");
            return null;
        }
        catch (ExecutionException e) {
            logger.severe("Execution exception while getting name of main application activity occured.");
            return null;
        }
    }

    public String getApplicationMainActivity(String apk) {
        return this.getApplicationMainActivity(new File(apk));
    }

    public String getApplicationBasePackage(File apk) {
        try {
            List results = this.executor.execute(this.getAAPTBadgingCommand(apk).getAsArray());
            return this.parseProperty(results, "package");
        }
        catch (InterruptedException e) {
            logger.severe("Process to get name of base application package was interrupted.");
            return null;
        }
        catch (ExecutionException e) {
            logger.severe("Execution exception while getting name of base application package occured.");
            return null;
        }
    }

    public List<String> getActivities(File apkFile) {
        ArrayList<String> activities = new ArrayList();
        try {
            List output = this.executor.execute(this.getAAPTXmlTreeCommand(apkFile).getAsArray());
            activities = this.filterActivities(output);
        }
        catch (InterruptedException e) {
            logger.severe("Process was interrupted. Unable to get list of activitis for file: " + apkFile.getAbsolutePath());
        }
        catch (ExecutionException e) {
            logger.severe("Unable to get list of activities for file: " + apkFile.getAbsolutePath());
        }
        return activities;
    }

    public List<String> getActivities(String apkFile) {
        return this.getActivities(new File(apkFile));
    }

    public String getApplicationBasePackage(String apk) {
        return this.getApplicationBasePackage(new File(apk));
    }

    private Command getAAPTBadgingCommand(File apk) {
        Command command = new Command();
        command.add(this.sdk.getAaptPath()).add("dump").add("badging").add(apk.getAbsolutePath());
        logger.log(Level.FINE, command.toString());
        return command;
    }

    private Command getAAPTXmlTreeCommand(File apkFile) {
        Command command = new Command();
        command.add(this.sdk.getAaptPath()).add("dump").add("xmltree").add(apkFile.getAbsolutePath()).add("AndroidManifest.xml");
        logger.log(Level.FINE, command.toString());
        return command;
    }

    private List<String> filterActivities(List<String> output) {
        ArrayList<String> activities = new ArrayList<String>();
        String packageName = this.getPackageName(output);
        for (int i = 0; i < output.size(); ++i) {
            if (!output.get(i).contains("activity")) continue;
            while (!output.get(++i).contains("android:name")) {
            }
            activities.add(packageName + this.getActivityName(output.get(i)));
        }
        return activities;
    }

    private String getPackageName(List<String> output) {
        for (String line : output) {
            Pattern packagePattern;
            Matcher m;
            if (!line.contains("package") || !(m = (packagePattern = Pattern.compile("package=['\"]([^'\"]+)['\"]")).matcher(line)).find()) continue;
            return m.group(1);
        }
        throw new IllegalStateException("no package name found in dump xmltree for AndroidManifest.xml");
    }

    private String getActivityName(String line) {
        Pattern activityPattern = Pattern.compile("=[\"]([^\"]+)[\"]");
        Matcher m = activityPattern.matcher(line);
        if (m.find()) {
            return m.group(1);
        }
        throw new IllegalStateException("no activity name found in AndroidManifest.xml on line: " + line);
    }

    private String parseProperty(List<String> lines, String property) {
        if (lines == null || lines.size() == 0) {
            return null;
        }
        Pattern packagePattern = Pattern.compile("name=['\"]([^'\"]+)['\"]");
        for (String line : lines) {
            Matcher m;
            if (!line.contains(property) || !(m = packagePattern.matcher(line)).find()) continue;
            return m.group(1);
        }
        return null;
    }
}

