/*
 * Decompiled with CFR 0.152.
 */
package org.arquillian.droidium.native_.activity;

import org.arquillian.droidium.container.api.ActivityManager;
import org.arquillian.droidium.native_.activity.ActivityWebDriverMapper;
import org.arquillian.droidium.native_.activity.NoMatchingWebDriverInstanceFoundException;
import org.jboss.arquillian.core.spi.Validate;
import org.openqa.selenium.WebDriver;

public class NativeActivityManager
implements ActivityManager {
    private ActivityWebDriverMapper activityWebDriverMapper;

    public NativeActivityManager(ActivityWebDriverMapper activityWebDriverMapper) {
        Validate.notNull((Object)activityWebDriverMapper, (String)"you passed null object");
        this.activityWebDriverMapper = activityWebDriverMapper;
    }

    public void startActivity(String activity) throws NoMatchingWebDriverInstanceFoundException {
        Validate.notNullOrEmpty((String)activity, (String)"Activity you want to start can not be a null object nor an empty string!");
        WebDriver driver = this.activityWebDriverMapper.getInstance(activity);
        if (driver == null) {
            throw new NoMatchingWebDriverInstanceFoundException("It seems you are trying to start an activity which is not backed by any WebDriver instance.");
        }
        driver.get("and-activity://" + activity);
    }

    public void startActivity(Class<?> activity) throws NoMatchingWebDriverInstanceFoundException {
        Validate.notNull(activity, (String)"Activity you want to start can not be a null object!");
        this.startActivity(activity.getName());
    }

    public void stopActivity(String activity) throws NoMatchingWebDriverInstanceFoundException {
        Validate.notNullOrEmpty((String)activity, (String)"Activity you want to stop can not be a null object nor an empty string!");
        WebDriver driver = this.activityWebDriverMapper.getInstance(activity);
        if (driver == null) {
            throw new NoMatchingWebDriverInstanceFoundException("It seems you are trying to stop an activity which is not backed by any WebDriver instance.");
        }
        driver.close();
    }

    public void stopActivity(Class<?> activity) throws NoMatchingWebDriverInstanceFoundException {
        Validate.notNull(activity, (String)"Activity you want to stop can not be a null object!");
        this.startActivity(activity.getName());
    }
}

