/*
 * Decompiled with CFR 0.152.
 */
package org.arkecosystem.crypto.transactions.builder;

import java.util.List;
import org.arkecosystem.crypto.enums.Fees;
import org.arkecosystem.crypto.identities.Address;
import org.arkecosystem.crypto.transactions.builder.AbstractTransactionBuilder;
import org.arkecosystem.crypto.transactions.types.Transaction;
import org.arkecosystem.crypto.transactions.types.Vote;

public class VoteBuilder
extends AbstractTransactionBuilder<VoteBuilder> {
    public VoteBuilder() {
        this.transaction.fee = Fees.VOTE.getValue();
    }

    public VoteBuilder addVotes(List votes) {
        this.transaction.asset.votes = votes;
        return this;
    }

    public VoteBuilder addVote(String vote) {
        this.transaction.asset.votes.add(vote);
        return this;
    }

    @Override
    public VoteBuilder sign(String passphrase) {
        this.transaction.recipientId = Address.fromPassphrase(passphrase, this.transaction.network);
        super.sign(passphrase);
        return this;
    }

    @Override
    public Transaction getTransactionInstance() {
        return new Vote();
    }

    @Override
    public VoteBuilder instance() {
        return this;
    }
}

