/*
 * Decompiled with CFR 0.152.
 */
package org.arkecosystem.crypto.transactions;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.arkecosystem.crypto.encoding.Hex;
import org.arkecosystem.crypto.enums.CoreTransactionTypes;
import org.arkecosystem.crypto.enums.TransactionTypeGroup;
import org.arkecosystem.crypto.transactions.types.DelegateRegistration;
import org.arkecosystem.crypto.transactions.types.DelegateResignation;
import org.arkecosystem.crypto.transactions.types.HtlcClaim;
import org.arkecosystem.crypto.transactions.types.HtlcLock;
import org.arkecosystem.crypto.transactions.types.HtlcRefund;
import org.arkecosystem.crypto.transactions.types.Ipfs;
import org.arkecosystem.crypto.transactions.types.MultiPayment;
import org.arkecosystem.crypto.transactions.types.MultiSignatureRegistration;
import org.arkecosystem.crypto.transactions.types.SecondSignatureRegistration;
import org.arkecosystem.crypto.transactions.types.Transaction;
import org.arkecosystem.crypto.transactions.types.Transfer;
import org.arkecosystem.crypto.transactions.types.Vote;

public class Deserializer {
    private final ByteBuffer buffer;
    private Transaction transaction;
    private final Map<Integer, Map<Integer, Transaction>> transactionGroups = new HashMap<Integer, Map<Integer, Transaction>>();

    public Deserializer(String serialized) {
        HashMap<Integer, Transaction> coreTransactionTypes = new HashMap<Integer, Transaction>();
        coreTransactionTypes.put(CoreTransactionTypes.TRANSFER.getValue(), new Transfer());
        coreTransactionTypes.put(CoreTransactionTypes.SECOND_SIGNATURE_REGISTRATION.getValue(), new SecondSignatureRegistration());
        coreTransactionTypes.put(CoreTransactionTypes.DELEGATE_REGISTRATION.getValue(), new DelegateRegistration());
        coreTransactionTypes.put(CoreTransactionTypes.VOTE.getValue(), new Vote());
        coreTransactionTypes.put(CoreTransactionTypes.MULTI_SIGNATURE_REGISTRATION.getValue(), new MultiSignatureRegistration());
        coreTransactionTypes.put(CoreTransactionTypes.IPFS.getValue(), new Ipfs());
        coreTransactionTypes.put(CoreTransactionTypes.MULTI_PAYMENT.getValue(), new MultiPayment());
        coreTransactionTypes.put(CoreTransactionTypes.DELEGATE_RESIGNATION.getValue(), new DelegateResignation());
        coreTransactionTypes.put(CoreTransactionTypes.HTLC_LOCK.getValue(), new HtlcLock());
        coreTransactionTypes.put(CoreTransactionTypes.HTLC_CLAIM.getValue(), new HtlcClaim());
        coreTransactionTypes.put(CoreTransactionTypes.HTLC_REFUND.getValue(), new HtlcRefund());
        this.transactionGroups.put(TransactionTypeGroup.CORE.getValue(), coreTransactionTypes);
        this.buffer = ByteBuffer.wrap(Hex.decode(serialized)).slice();
        this.buffer.order(ByteOrder.LITTLE_ENDIAN);
    }

    public Transaction deserialize() {
        this.buffer.get();
        this.deserializeCommon();
        this.deserializeVendorField();
        this.transaction.deserialize(this.buffer);
        this.deserializeSignatures();
        this.transaction.computeId();
        return this.transaction;
    }

    private void deserializeCommon() {
        byte version = this.buffer.get();
        byte network = this.buffer.get();
        int typeGroup = this.buffer.getInt();
        short type = this.buffer.getShort();
        long nonce = this.buffer.getLong();
        this.transaction = this.transactionGroups.get(typeGroup).get(type);
        this.transaction.version = version;
        this.transaction.network = network;
        this.transaction.typeGroup = typeGroup;
        this.transaction.type = type;
        this.transaction.nonce = nonce;
        byte[] senderPublicKey = new byte[33];
        this.buffer.get(senderPublicKey);
        this.transaction.senderPublicKey = Hex.encode(senderPublicKey);
        this.transaction.fee = this.buffer.getLong();
    }

    private void deserializeVendorField() {
        byte vendorFieldLength = this.buffer.get();
        if (vendorFieldLength > 0) {
            byte[] vendorField = new byte[vendorFieldLength];
            this.buffer.get(vendorField);
            this.transaction.vendorField = new String(vendorField);
        }
    }

    private void deserializeSignatures() {
        this.deserializeSchnorrOrEcdsa();
    }

    private void deserializeSchnorrOrEcdsa() {
        if (this.detectSchnorr()) {
            this.deserializeSchnorr();
        } else {
            this.deserializeEcdsa();
        }
    }

    private void deserializeEcdsa() {
        byte[] signatureBuffer;
        int signatureLength;
        if (this.buffer.remaining() != 0) {
            signatureLength = this.currentSignatureLength();
            signatureBuffer = new byte[signatureLength];
            this.buffer.get(signatureBuffer);
            this.transaction.signature = Hex.encode(signatureBuffer);
        }
        if (this.buffer.remaining() != 0) {
            signatureLength = this.currentSignatureLength();
            signatureBuffer = new byte[signatureLength];
            this.buffer.get(signatureBuffer);
            this.transaction.secondSignature = Hex.encode(signatureBuffer);
        }
    }

    private boolean canReadNonMultiSignature() {
        return this.buffer.hasRemaining() && (this.buffer.remaining() % 64 == 0 || this.buffer.remaining() % 65 != 0);
    }

    private void deserializeSchnorr() {
        byte[] signatureBuffer;
        if (this.canReadNonMultiSignature()) {
            signatureBuffer = new byte[64];
            this.buffer.get(signatureBuffer);
            this.transaction.signature = Hex.encode(signatureBuffer);
        }
        if (this.canReadNonMultiSignature()) {
            signatureBuffer = new byte[64];
            this.buffer.get(signatureBuffer);
            this.transaction.secondSignature = Hex.encode(signatureBuffer);
        }
        if (this.buffer.hasRemaining()) {
            if (this.buffer.remaining() % 65 == 0) {
                this.transaction.signatures = new ArrayList<String>();
                int count = this.buffer.remaining() / 65;
                HashSet<Integer> publicKeyIndexes = new HashSet<Integer>();
                for (int i = 0; i < count; ++i) {
                    byte[] signatureBuffer2 = new byte[65];
                    this.buffer.get(signatureBuffer2);
                    String multiSignaturePart = Hex.encode(signatureBuffer2);
                    int publicKeyIndex = Integer.parseInt(multiSignaturePart.substring(0, 2), 16);
                    if (publicKeyIndexes.contains(publicKeyIndex)) {
                        throw new RuntimeException("Duplicate participant in multi signature");
                    }
                    publicKeyIndexes.add(publicKeyIndex);
                    this.transaction.signatures.add(multiSignaturePart);
                }
            } else {
                throw new RuntimeException("signature buffer not exhausted");
            }
        }
    }

    private boolean detectSchnorr() {
        int remaining = this.buffer.remaining();
        if (remaining == 64 || remaining == 128) {
            return true;
        }
        if (remaining % 65 == 0) {
            return true;
        }
        return (remaining - 64) % 65 == 0 || (remaining - 128) % 65 == 0;
    }

    private int currentSignatureLength() {
        int mark = this.buffer.position();
        this.buffer.position(mark + 1);
        String length = String.valueOf(this.buffer.get());
        int signatureLength = Integer.parseInt(length) + 2;
        this.buffer.position(mark);
        return signatureLength;
    }

    public void setNewTransactionType(Transaction transaction) {
        if (this.transactionGroups.containsKey(transaction.getTransactionTypeGroup())) {
            this.transactionGroups.get(transaction.getTransactionTypeGroup()).put(transaction.getTransactionType(), transaction);
        } else {
            HashMap<Integer, Transaction> newTransactionGroup = new HashMap<Integer, Transaction>();
            newTransactionGroup.put(transaction.getTransactionType(), transaction);
            this.transactionGroups.put(transaction.getTransactionTypeGroup(), newTransactionGroup);
        }
    }

    public boolean hasTransactionType(int typeGroup, int type) {
        if (!this.transactionGroups.containsKey(typeGroup)) {
            return false;
        }
        return this.transactionGroups.get(typeGroup).containsKey(type);
    }
}

