/*
 * Decompiled with CFR 0.152.
 */
package org.archifacts.integration.jmolecules;

import com.tngtech.archunit.core.domain.JavaClass;
import com.tngtech.archunit.core.domain.JavaMethod;
import java.util.stream.Stream;
import org.archifacts.core.descriptor.SourceBasedArtifactRelationshipDescriptor;
import org.archifacts.core.model.Artifact;
import org.archifacts.core.model.ArtifactRelationshipRole;
import org.jmolecules.event.annotation.DomainEventHandler;

final class EventHandlerDescriptor
implements SourceBasedArtifactRelationshipDescriptor {
    private static final ArtifactRelationshipRole ROLE = ArtifactRelationshipRole.of((String)"handles");

    EventHandlerDescriptor() {
    }

    public ArtifactRelationshipRole role() {
        return ROLE;
    }

    public boolean isSource(Artifact sourceCandidateArtifact) {
        return sourceCandidateArtifact.getJavaClass().getMethods().stream().anyMatch(this::isValidEventHandler);
    }

    public Stream<JavaClass> targets(JavaClass sourceClass) {
        return sourceClass.getMethods().stream().filter(this::isValidEventHandler).map(method -> (JavaClass)method.getRawParameterTypes().get(0));
    }

    private boolean isValidEventHandler(JavaMethod method) {
        return method.isAnnotatedWith(DomainEventHandler.class) && !method.getRawParameterTypes().isEmpty();
    }
}

