/*
 * Decompiled with CFR 0.152.
 */
package org.archifacts.integration.c4.model;

import com.structurizr.model.Component;
import com.structurizr.model.Container;
import com.structurizr.model.Relationship;
import com.structurizr.model.SoftwareSystem;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.archifacts.core.model.Application;
import org.archifacts.core.model.Artifact;
import org.archifacts.core.model.ArtifactContainer;
import org.archifacts.core.model.ArtifactRelationship;
import org.archifacts.core.model.BuildingBlock;
import org.archifacts.core.model.Named;

public final class C4ModelTransformer {
    private final Map<ArtifactContainer, Container> containerMap = new HashMap<ArtifactContainer, Container>();
    private final Map<Artifact, Component> componentMap = new HashMap<Artifact, Component>();
    private final Map<ArtifactRelationship, Relationship> relationshipMap = new HashMap<ArtifactRelationship, Relationship>();
    private Optional<Container> noContainerContainer = Optional.empty();
    private final Application application;
    private final SoftwareSystem softwareSystem;

    private static <T> Supplier<T> memoize(Supplier<T> valueSupplier) {
        return new CachingSupplier<T>(valueSupplier);
    }

    public C4ModelTransformer(Application application, SoftwareSystem softwareSystem) {
        this.application = application;
        this.softwareSystem = softwareSystem;
        this.transform();
    }

    private void transform() {
        this.transformContainers();
        this.transformRelationships();
    }

    private void transformContainers() {
        Supplier<Container> noContainerContainerSupplier = C4ModelTransformer.memoize(() -> {
            Container noContainerContainer = this.softwareSystem.addContainer("no-container");
            this.noContainerContainer = Optional.of(noContainerContainer);
            return noContainerContainer;
        });
        HashMap containerArtifactsMap = new HashMap();
        this.application.getArtifacts().forEach(artifact -> {
            Container container = artifact.getContainer().map(artifactContainer -> this.containerMap.computeIfAbsent((ArtifactContainer)artifactContainer, m -> this.softwareSystem.addContainer(m.getName(), null, artifactContainer.getType().getName()))).orElseGet(noContainerContainerSupplier);
            List artifacts = containerArtifactsMap.computeIfAbsent(container, x -> new ArrayList());
            artifacts.add(artifact);
        });
        containerArtifactsMap.entrySet().forEach(entry -> {
            Container container = (Container)entry.getKey();
            List artifacts = (List)entry.getValue();
            boolean containsAmbiguousNames = this.containsAmbiguousNames(artifacts);
            artifacts.forEach(artifact -> {
                String componentName = containsAmbiguousNames ? artifact.getJavaClass().getFullName() : artifact.getName();
                Component component = container.addComponent(componentName, artifact.getJavaClass().getName(), null, this.getTechnology((Artifact)artifact));
                this.componentMap.put((Artifact)artifact, component);
            });
        });
    }

    private void transformRelationships() {
        this.application.getRelationships().forEach(artifactRelationship -> {
            Component sourceComponent = this.componentMap.get(artifactRelationship.getSource());
            Component targetComponent = this.componentMap.get(artifactRelationship.getTarget());
            Relationship relationship = sourceComponent.uses(targetComponent, artifactRelationship.getRole().getName());
            this.relationshipMap.put((ArtifactRelationship)artifactRelationship, relationship);
        });
    }

    private boolean containsAmbiguousNames(List<? extends Named> named) {
        return named.stream().map(Named::getName).distinct().count() < (long)named.size();
    }

    private String getTechnology(Artifact artifact) {
        if (artifact instanceof BuildingBlock) {
            return ((BuildingBlock)artifact).getType().getName();
        }
        return null;
    }

    public Set<Container> getContainers(Predicate<ArtifactContainer> predicate) {
        return this.containerMap.entrySet().stream().filter(entry -> predicate.test((ArtifactContainer)entry.getKey())).map(Map.Entry::getValue).collect(Collectors.toUnmodifiableSet());
    }

    public Set<Component> getComponents(Predicate<Artifact> predicate) {
        return this.componentMap.entrySet().stream().filter(entry -> predicate.test((Artifact)entry.getKey())).map(Map.Entry::getValue).collect(Collectors.toUnmodifiableSet());
    }

    public Set<Relationship> getRelationships(Predicate<ArtifactRelationship> predicate) {
        return this.relationshipMap.entrySet().stream().filter(entry -> predicate.test((ArtifactRelationship)entry.getKey())).map(Map.Entry::getValue).collect(Collectors.toUnmodifiableSet());
    }

    public Optional<Container> getNoContainerContainer() {
        return this.noContainerContainer;
    }

    private static final class CachingSupplier<T>
    implements Supplier<T> {
        private T cachedValue;
        private final Supplier<T> originalSupplier;

        public CachingSupplier(Supplier<T> originalSupplier) {
            this.originalSupplier = originalSupplier;
        }

        @Override
        public T get() {
            if (this.cachedValue == null) {
                this.cachedValue = this.originalSupplier.get();
            }
            return this.cachedValue;
        }
    }
}

