/*
 * Decompiled with CFR 0.152.
 */
package org.archifacts.integration.axon;

import com.tngtech.archunit.core.domain.JavaClass;
import com.tngtech.archunit.core.domain.JavaCodeUnit;
import com.tngtech.archunit.core.domain.JavaParameterizedType;
import com.tngtech.archunit.core.domain.JavaType;
import java.lang.annotation.Annotation;
import java.util.stream.Stream;
import org.archifacts.core.descriptor.SourceBasedArtifactRelationshipDescriptor;
import org.archifacts.core.model.Artifact;
import org.archifacts.core.model.ArtifactRelationshipRole;
import org.axonframework.messaging.Message;

abstract class AbstractHandlerDescriptor
implements SourceBasedArtifactRelationshipDescriptor {
    private static final ArtifactRelationshipRole ROLE = ArtifactRelationshipRole.of((String)"handles");

    AbstractHandlerDescriptor() {
    }

    public ArtifactRelationshipRole role() {
        return ROLE;
    }

    public boolean isSource(Artifact sourceCandidateArtifact) {
        return sourceCandidateArtifact.getJavaClass().getCodeUnits().stream().anyMatch(this::isValidHandler);
    }

    public Stream<JavaClass> targets(JavaClass sourceClass) {
        return sourceClass.getCodeUnits().stream().filter(this::isValidHandler).map(method -> (JavaType)method.getParameterTypes().get(0)).map(javaType -> this.toJavaClass((JavaType)javaType));
    }

    private boolean isValidHandler(JavaCodeUnit codeUnit) {
        return codeUnit.isMetaAnnotatedWith(this.getAnnotationClass()) && !codeUnit.getParameterTypes().isEmpty();
    }

    private JavaClass toJavaClass(JavaType javaType) {
        JavaClass javaClass = javaType.toErasure();
        if (javaClass.isAssignableTo(Message.class) && javaType instanceof JavaParameterizedType) {
            JavaParameterizedType javaParameterizedType = (JavaParameterizedType)javaType;
            return ((JavaType)javaParameterizedType.getActualTypeArguments().get(0)).toErasure();
        }
        return javaClass;
    }

    protected abstract Class<? extends Annotation> getAnnotationClass();
}

