/*
 * Decompiled with CFR 0.152.
 */
package org.archifacts.integration.asciidoc;

import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.archifacts.integration.asciidoc.AsciiDocElement;

public final class AsciiDoc {
    private final List<AsciiDocElement> docElements = new ArrayList<AsciiDocElement>();

    public void addDocElement(AsciiDocElement docElement) {
        this.docElements.add(docElement);
    }

    public void writeToWriter(Writer writer) throws IOException {
        Objects.requireNonNull(writer, "The writer must not be null.");
        writer.write(this.render());
    }

    private String render() {
        StringBuilder stringBuilder = new StringBuilder();
        this.docElements.stream().map(AsciiDocElement::render).forEach(renderedDocElement -> stringBuilder.append((String)renderedDocElement).append('\n'));
        return stringBuilder.toString();
    }
}

