/*
 * Decompiled with CFR 0.152.
 */
package org.appng.maven.plugins.appngizer;

import java.net.URISyntaxException;
import org.apache.commons.lang3.StringUtils;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.appng.appngizer.model.xml.Package;
import org.appng.maven.plugins.appngizer.AppNGizerMojo;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;

@Mojo(name="install", defaultPhase=LifecyclePhase.PACKAGE)
public class InstallMojo
extends AppNGizerMojo {
    @Parameter(property="site")
    protected String site;
    @Parameter(property="activate")
    protected boolean activate = false;

    public void execute() throws MojoExecutionException, MojoFailureException {
        try {
            this.determineFile();
            this.login();
            this.getRepository();
            ResponseEntity<Package> uploaded = this.upload();
            if (uploaded.getStatusCode().equals((Object)HttpStatus.OK)) {
                this.getLog().info((CharSequence)"Success!");
                Package uploadPackage = (Package)uploaded.getBody();
                boolean isSiteSet = StringUtils.isNotBlank((CharSequence)this.site);
                if (uploadPackage.isInstalled()) {
                    this.getLog().info((CharSequence)String.format("%s %s %s is already installed", uploadPackage.getName(), uploadPackage.getVersion(), uploadPackage.getTimestamp()));
                    if (isSiteSet) {
                        this.getLog().info((CharSequence)String.format("Skipping site reload for site %s", this.site));
                    }
                } else {
                    this.getLog().info((CharSequence)String.format("Installing %s %s %s", uploadPackage.getName(), uploadPackage.getVersion(), uploadPackage.getTimestamp()));
                    HttpHeaders installHeader = this.getHeader();
                    installHeader.setContentType(MediaType.APPLICATION_XML);
                    ResponseEntity<Package> installPackage = this.send(uploadPackage, installHeader, HttpMethod.PUT, "repository/" + this.repository + "/install", Package.class);
                    Package installedPackage = (Package)installPackage.getBody();
                    if (HttpStatus.OK.equals((Object)installPackage.getStatusCode())) {
                        if (isSiteSet) {
                            boolean doReload = true;
                            if (this.activate) {
                                this.getLog().info((CharSequence)("Activating application " + installedPackage.getName() + " for site " + this.site));
                                ResponseEntity<Void> response = this.send(null, this.getHeader(), HttpMethod.POST, "site/" + this.site + "/application/" + installedPackage.getName(), Void.class);
                                HttpStatus statusCode = response.getStatusCode();
                                if (statusCode.is3xxRedirection()) {
                                    this.getLog().info((CharSequence)("Activated application " + installedPackage.getName() + " for site " + this.site));
                                } else if (HttpStatus.METHOD_NOT_ALLOWED.equals((Object)statusCode)) {
                                    this.getLog().info((CharSequence)("Application " + installedPackage.getName() + " already active for site " + this.site));
                                } else {
                                    doReload = false;
                                    this.getLog().error((CharSequence)("error installing package " + installedPackage.getName() + ", return code was " + installPackage.getStatusCode()));
                                }
                            }
                            if (doReload) {
                                this.getLog().info((CharSequence)("Reloading site " + this.site));
                                this.send(null, this.getHeader(), HttpMethod.PUT, "site/" + this.site + "/reload", Void.class);
                            } else {
                                this.getLog().info((CharSequence)("NOT reloading site " + this.site));
                            }
                        } else {
                            this.getLog().debug((CharSequence)"no site set, skipping activation/reloading");
                        }
                    } else {
                        this.getLog().error((CharSequence)("error installing package " + uploadPackage.getName() + ", return code was " + installPackage.getStatusCode()));
                    }
                }
            } else {
                this.getLog().error((CharSequence)("error uploading package , return code was " + uploaded.getStatusCode()));
            }
        }
        catch (URISyntaxException e) {
            throw new MojoExecutionException("error during upload", (Exception)e);
        }
    }
}

