/*
 * Decompiled with CFR 0.152.
 */
package org.appng.maven.plugins.appngizer;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Parameter;
import org.appng.appngizer.model.xml.Home;
import org.appng.appngizer.model.xml.Package;
import org.appng.appngizer.model.xml.Repository;
import org.springframework.core.io.FileSystemResource;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpOutputMessage;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.RequestEntity;
import org.springframework.http.ResponseEntity;
import org.springframework.http.converter.xml.Jaxb2RootElementHttpMessageConverter;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.DefaultResponseErrorHandler;
import org.springframework.web.client.ResponseErrorHandler;
import org.springframework.web.client.RestTemplate;

abstract class AppNGizerMojo
extends AbstractMojo {
    @Parameter(property="sharedSecret", defaultValue="loreipsum", required=true)
    protected String sharedSecret;
    @Parameter(property="repository", defaultValue="Local", required=true)
    protected String repository;
    @Parameter(property="endpoint", defaultValue="http://localhost:8080/appNGizer/", required=true)
    protected URL endpoint;
    protected File file;
    @Parameter(defaultValue="${project.build.directory}", readonly=true)
    protected File targetFolder;
    @Parameter(defaultValue="${project.artifactId}-${project.version}", readonly=true)
    protected String targetFile;
    @Parameter(property="baseAuthUser")
    protected String baseAuthUser;
    @Parameter(property="baseAuthPassword")
    protected String baseAuthPassword;
    protected RestTemplate restTemplate = new RestTemplate();
    private Jaxb2RootElementHttpMessageConverter jaxbConverter = new Jaxb2RootElementHttpMessageConverter();
    private String cookie;

    protected AppNGizerMojo() {
        this.restTemplate.getMessageConverters().add(this.jaxbConverter);
        this.restTemplate.setErrorHandler((ResponseErrorHandler)new DefaultResponseErrorHandler(){

            protected boolean hasError(HttpStatus statusCode) {
                return statusCode.is5xxServerError();
            }
        });
    }

    protected <T> ResponseEntity<T> send(Object requestObject, HttpHeaders header, HttpMethod method, String path, Class<T> resultType) throws URISyntaxException {
        return this.send(requestObject, header, method, new URI(this.endpoint + path), resultType);
    }

    private <T> ResponseEntity<T> send(Object requestObject, HttpHeaders headers, HttpMethod method, URI path, Class<T> resultType) throws URISyntaxException {
        List cookies;
        RequestEntity req = new RequestEntity(requestObject, (MultiValueMap)headers, method, path);
        this.getLog().debug((CharSequence)("out: " + req));
        if (null != requestObject) {
            this.debugBody(requestObject, headers.getContentType());
        }
        ResponseEntity response = this.restTemplate.exchange(req.getUrl(), req.getMethod(), (HttpEntity)req, resultType);
        this.getLog().debug((CharSequence)("in: " + response));
        if (null != response.getBody()) {
            this.debugBody(response.getBody(), response.getHeaders().getContentType());
        }
        if (null != (cookies = response.getHeaders().get((Object)"Set-Cookie"))) {
            this.cookie = cookies.stream().collect(Collectors.joining(";"));
        }
        return response;
    }

    protected void debugBody(Object o, MediaType mediaType) {
        if (this.getLog().isDebugEnabled() && MediaType.APPLICATION_XML.equals((Object)mediaType)) {
            try {
                final ByteArrayOutputStream out = new ByteArrayOutputStream();
                this.jaxbConverter.write(o, mediaType, new HttpOutputMessage(){

                    public HttpHeaders getHeaders() {
                        return new HttpHeaders();
                    }

                    public OutputStream getBody() throws IOException {
                        return out;
                    }
                });
                this.getLog().debug((CharSequence)((Object)out).toString());
            }
            catch (IOException e) {
                this.getLog().warn((CharSequence)"error writing body", (Throwable)e);
            }
        }
    }

    protected HttpHeaders getHeader() {
        HttpHeaders headers = new HttpHeaders();
        if (StringUtils.isNotBlank((CharSequence)this.cookie)) {
            headers.set("Cookie", this.cookie);
        }
        if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{this.baseAuthUser, this.baseAuthPassword})) {
            String userAndPass = this.baseAuthUser + ":" + this.baseAuthPassword;
            byte[] encodedAuth = Base64.getEncoder().encode(userAndPass.getBytes(StandardCharsets.UTF_8));
            headers.add("Authorization", "Basic " + new String(encodedAuth));
        }
        return headers;
    }

    protected void login() throws URISyntaxException {
        HttpHeaders loginHeader = this.getHeader();
        loginHeader.setContentType(MediaType.TEXT_PLAIN);
        this.getLog().info((CharSequence)("Connecting to " + this.endpoint));
        this.send((Object)this.sharedSecret, loginHeader, HttpMethod.POST, this.endpoint.toURI(), Home.class);
    }

    protected ResponseEntity<Repository> getRepository() throws URISyntaxException {
        ResponseEntity<Repository> repo = this.send(null, this.getHeader(), HttpMethod.GET, "repository/" + this.repository, Repository.class);
        this.getLog().info((CharSequence)("Retrieved repo " + ((Repository)repo.getBody()).getName() + " at " + ((Repository)repo.getBody()).getSelf()));
        return repo;
    }

    protected ResponseEntity<Package> upload() throws URISyntaxException {
        LinkedMultiValueMap multipartRequest = new LinkedMultiValueMap();
        multipartRequest.add((Object)"file", (Object)new FileSystemResource(this.file));
        HttpHeaders uploadHeader = this.getHeader();
        uploadHeader.setContentType(MediaType.MULTIPART_FORM_DATA);
        this.getLog().info((CharSequence)("Uploading file " + this.file));
        return this.send((Object)multipartRequest, uploadHeader, HttpMethod.POST, "repository/" + this.repository + "/upload", Package.class);
    }

    protected ResponseEntity<Void> install(Package uploadPackage, String cookie) throws URISyntaxException {
        this.getLog().info((CharSequence)String.format("Installing %s %s %s", uploadPackage.getName(), uploadPackage.getVersion(), uploadPackage.getTimestamp()));
        HttpHeaders installHeader = this.getHeader();
        installHeader.setContentType(MediaType.APPLICATION_XML);
        return this.send((Object)uploadPackage, installHeader, HttpMethod.PUT, "repository/" + this.repository + "/install", Void.class);
    }

    protected void determineFile() throws MojoExecutionException {
        String[] files = this.targetFolder.list(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.startsWith(AppNGizerMojo.this.targetFile) && name.endsWith(".zip");
            }
        });
        if (null == files) {
            throw new MojoExecutionException(String.format("No archive file(s) starting with %s found in %s", this.targetFile, this.targetFolder.getAbsolutePath()));
        }
        ArrayList<String> sortedFiles = new ArrayList<String>(Arrays.asList(files));
        Collections.sort(sortedFiles);
        this.file = new File(this.targetFolder, (String)sortedFiles.get(sortedFiles.size() - 1));
        this.getLog().info((CharSequence)("Found archive " + this.file.getAbsolutePath()));
    }
}

