/*
 * Decompiled with CFR 0.152.
 */
package org.appng.xml.transformation;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Map;
import java.util.TreeMap;
import java.util.TreeSet;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Comment;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class StyleSheetProvider {
    private static final Logger LOGGER = LoggerFactory.getLogger(StyleSheetProvider.class);
    private static final String XSL_INCLUDE = "xsl:include";
    private InputStream masterSource;
    private DocumentBuilderFactory documentBuilderFactory;
    private TransformerFactory transformerFactory;
    private DocumentBuilder documentBuilder;
    private Transformer transformer;
    private String insertBefore;
    private Map<String, InputStream> styleReferences = new TreeMap<String, InputStream>();
    private String name;
    private String templateRoot;

    public void init() {
        try {
            this.documentBuilder = this.getDocumentBuilderFactory().newDocumentBuilder();
            this.transformer = this.getTransformerFactory().newTransformer();
        }
        catch (Exception e) {
            LOGGER.error(String.format("[%s] error setting up StyleSheetProvider, instance will not work!", this.name), (Throwable)e);
        }
    }

    public void setMasterSource(InputStream masterXsl, String templateRoot) {
        try {
            this.masterSource = masterXsl;
            this.templateRoot = templateRoot;
        }
        catch (Exception e) {
            LOGGER.error(String.format("[%s] error setting up StyleSheetProvider, instance will not work!", this.name), (Throwable)e);
        }
    }

    public void addStyleSheet(InputStream styleSheet, String reference) {
        try {
            if (this.styleReferences.containsKey(reference)) {
                LOGGER.warn("[{}] stylesheet '{}' is already defined, contents will be overridden!", (Object)this.name, (Object)reference);
            }
            this.styleReferences.put(reference, styleSheet);
            LOGGER.trace("[{}] adding stylesheet with reference '{}'", (Object)this.name, (Object)reference);
        }
        catch (Exception e) {
            LOGGER.error(String.format("[%s] error parsing stylesheet '%s'", this.name, reference), (Throwable)e);
        }
    }

    public byte[] getStyleSheet(boolean deleteIncludes) {
        return this.getStyleSheet(deleteIncludes, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public byte[] getStyleSheet(boolean deleteIncludes, OutputStream additionalOut) {
        try {
            byte[] byArray;
            Throwable throwable;
            ByteArrayOutputStream outputStream;
            block23: {
                block24: {
                    Document masterDoc = this.documentBuilder.parse(this.masterSource);
                    Node rootNode = masterDoc.getFirstChild();
                    Node insertionPoint = null;
                    NodeList nodes = rootNode.getChildNodes();
                    ArrayList<Node> includes = new ArrayList<Node>();
                    int hits = nodes.getLength();
                    for (int i = 0; i < hits; ++i) {
                        Node node = nodes.item(i);
                        String nodeName = node.getNodeName();
                        if (XSL_INCLUDE.equals(nodeName)) {
                            includes.add(node);
                            continue;
                        }
                        if (!this.insertBefore.equals(nodeName)) continue;
                        insertionPoint = node;
                    }
                    for (Node node : includes) {
                        Node href = node.getAttributes().getNamedItem("href");
                        String reference = href.getTextContent();
                        rootNode.removeChild(node);
                        if (deleteIncludes) {
                            LOGGER.trace("[{}] removing reference to '{}'", (Object)this.name, (Object)reference);
                            continue;
                        }
                        File file = new File(this.templateRoot, reference);
                        this.styleReferences.put(reference, new FileInputStream(file));
                    }
                    for (String reference : this.styleReferences.keySet()) {
                        this.includeStyleSheet(rootNode, insertionPoint, reference);
                    }
                    outputStream = new ByteArrayOutputStream();
                    throwable = null;
                    DOMSource domSource = new DOMSource(masterDoc);
                    if (additionalOut != null) {
                        this.transformer.transform(domSource, new StreamResult(additionalOut));
                    }
                    this.transformer.transform(domSource, new StreamResult(outputStream));
                    LOGGER.debug("stylesheet complete");
                    byArray = outputStream.toByteArray();
                    if (outputStream == null) break block23;
                    if (throwable == null) break block24;
                    try {
                        outputStream.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    break block23;
                }
                outputStream.close();
            }
            return byArray;
            catch (Throwable throwable3) {
                try {
                    try {
                        throwable = throwable3;
                        throw throwable3;
                    }
                    catch (Throwable throwable4) {
                        if (outputStream != null) {
                            if (throwable != null) {
                                try {
                                    outputStream.close();
                                }
                                catch (Throwable throwable5) {
                                    throwable.addSuppressed(throwable5);
                                }
                            } else {
                                outputStream.close();
                            }
                        }
                        throw throwable4;
                    }
                }
                catch (Exception e) {
                    LOGGER.error(String.format("[%s] error writing stylesheet", this.name), (Throwable)e);
                }
            }
        }
        finally {
            this.close(this.masterSource);
        }
        return null;
    }

    protected void close(InputStream is) {
        try {
            is.close();
        }
        catch (IOException e) {
            LOGGER.error("error closing stream", (Throwable)e);
        }
        finally {
            is = null;
        }
    }

    private void includeStyleSheet(Node rootNode, Node insertionPoint, String reference) throws SAXException, IOException {
        InputStream inputStream = this.styleReferences.get(reference);
        Document styleSheetDoc = this.getDocumentBuilder().parse(inputStream);
        if (null == styleSheetDoc) {
            LOGGER.warn("[{}] referenced stylesheet '{}' could not be found, inclusion skipped!", (Object)this.name, (Object)reference);
        } else {
            LOGGER.trace("[{}] including referenced stylesheet '{}'", (Object)this.name, (Object)reference);
            NodeList childNodes = styleSheetDoc.getFirstChild().getChildNodes();
            Document ownerDocument = rootNode.getOwnerDocument();
            Comment beginComment = ownerDocument.createComment("[BEGIN] embed '" + reference + "'");
            Comment endComment = ownerDocument.createComment("[END] embed '" + reference + "'");
            Node inserted = rootNode.insertBefore(endComment, insertionPoint);
            for (int i = 0; i < childNodes.getLength(); ++i) {
                Node sourceNode = childNodes.item(i);
                Node adoptedNode = ownerDocument.importNode(sourceNode, true);
                inserted = rootNode.insertBefore(adoptedNode, inserted);
            }
            inserted = rootNode.insertBefore(beginComment, inserted);
        }
    }

    public DocumentBuilderFactory getDocumentBuilderFactory() {
        return this.documentBuilderFactory;
    }

    public void setDocumentBuilderFactory(DocumentBuilderFactory documentBuilderFactory) {
        this.documentBuilderFactory = documentBuilderFactory;
    }

    public TransformerFactory getTransformerFactory() {
        return this.transformerFactory;
    }

    public void setTransformerFactory(TransformerFactory transformerFactory) {
        this.transformerFactory = transformerFactory;
    }

    public DocumentBuilder getDocumentBuilder() {
        return this.documentBuilder;
    }

    public void setDocumentBuilder(DocumentBuilder documentBuilder) {
        this.documentBuilder = documentBuilder;
    }

    public Transformer getTransformer() {
        return this.transformer;
    }

    public void setTransformer(Transformer transformer) {
        this.transformer = transformer;
    }

    public String getInsertBefore() {
        return this.insertBefore;
    }

    public void setInsertBefore(String insertBefore) {
        this.insertBefore = insertBefore;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getId() {
        return StringUtils.join(new TreeSet<String>(this.styleReferences.keySet()), (String)",");
    }

    public void cleanup() {
        new ArrayList<String>(this.styleReferences.keySet()).forEach(k -> this.close(this.styleReferences.remove(k)));
    }

    public boolean isValid() {
        return null != this.masterSource;
    }
}

