/*
 * Decompiled with CFR 0.152.
 */
package org.appng.xml;

import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import javax.xml.bind.ValidationEvent;
import javax.xml.bind.ValidationEventHandler;
import javax.xml.bind.ValidationEventLocator;
import javax.xml.namespace.QName;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import org.apache.commons.io.output.WriterOutputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class MarshallService {
    private static final Logger LOGGER = LoggerFactory.getLogger(MarshallService.class);
    public static final String NS_PLATFORM = "http://www.appng.org/schema/platform";
    public static final String NS_APPLICATION = "http://www.appng.org/schema/application";
    private DocumentBuilderFactory documentBuilderFactory;
    private TransformerFactory transformerFactory;
    private Marshaller marshaller;
    private Unmarshaller unmarshaller;
    private boolean throwMarshallingError = false;
    private boolean throwUnmarshallingError = false;
    private List<String> cdataElements;
    private boolean useSchema = false;
    private boolean prettyPrint = false;
    private AppNGSchema schema;
    private String schemaLocation;
    private MarshallEventHandler marshallingEventHandler;
    private MarshallEventHandler unmarshallingEventHandler;

    public AppNGSchema getSchema() {
        return this.schema;
    }

    public void setSchema(AppNGSchema schema) {
        this.schema = schema;
    }

    public boolean isUseSchema() {
        return this.useSchema;
    }

    public void setUseSchema(boolean useSchema) {
        this.useSchema = useSchema;
    }

    public boolean isPrettyPrint() {
        return this.prettyPrint;
    }

    public void setPrettyPrint(boolean prettyPrint) {
        this.prettyPrint = prettyPrint;
    }

    public MarshallService() {
    }

    MarshallService(AppNGSchema schema) {
        this.setSchema(schema);
        this.init();
    }

    public void init() {
        URL schemaUrl = MarshallService.class.getClassLoader().getResource(this.schema.getXsd());
        try {
            this.marshaller = this.schema.getContext().createMarshaller();
            this.unmarshaller = this.schema.getContext().createUnmarshaller();
            if (this.prettyPrint) {
                this.marshaller.setProperty("jaxb.formatted.output", (Object)Boolean.TRUE);
            }
            if (this.useSchema) {
                LOGGER.trace("using schema {}", (Object)schemaUrl);
                SchemaFactory sf = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
                Schema schema = sf.newSchema(schemaUrl);
                this.marshaller.setSchema(schema);
                this.unmarshaller.setSchema(schema);
                this.marshallingEventHandler = new MarshallEventHandler(this.throwMarshallingError);
                this.unmarshallingEventHandler = new MarshallEventHandler(this.throwUnmarshallingError);
                this.marshaller.setEventHandler((ValidationEventHandler)this.marshallingEventHandler);
                this.unmarshaller.setEventHandler((ValidationEventHandler)this.unmarshallingEventHandler);
                if (null != this.schemaLocation) {
                    LOGGER.trace("schemaLocation is {}", (Object)this.schemaLocation);
                    this.marshaller.setProperty("jaxb.schemaLocation", (Object)(this.schema.getNamespace() + " " + this.schemaLocation));
                }
            }
        }
        catch (JAXBException e) {
            LOGGER.error("error while initializing JAXB", (Throwable)e);
        }
        catch (SAXException e) {
            LOGGER.error(String.format("error while Schema from url %s", schemaUrl), (Throwable)e);
        }
    }

    public static MarshallService getApplicationMarshallService() throws JAXBException {
        MarshallService marshallService = new MarshallService();
        marshallService.setSchema(AppNGSchema.APPLICATION);
        marshallService.init();
        return marshallService;
    }

    public void marshal(Object data, OutputStream out) throws ParserConfigurationException, JAXBException, TransformerException {
        Document document = this.marshallToDocument(data);
        this.buildTransformer().transform(new DOMSource(document), new StreamResult(out));
        this.logValidationMessages(this.marshallingEventHandler);
    }

    public String marshal(Object data) throws ParserConfigurationException, JAXBException, TransformerException {
        Document document = this.marshallToDocument(data);
        DOMSource xmlSource = new DOMSource(document);
        StringWriter writer = new StringWriter();
        this.buildTransformer().transform(xmlSource, new StreamResult(writer));
        this.logValidationMessages(this.marshallingEventHandler);
        return writer.toString();
    }

    private void logValidationMessages(MarshallEventHandler eventHandler) {
        if (null != eventHandler) {
            Collection<ErrorItem> errorItems = eventHandler.getErrorItems().values();
            String separator = System.getProperty("line.separator");
            for (ErrorItem errorItem : errorItems) {
                StringBuilder sb = new StringBuilder("error on " + errorItem.object + ":");
                sb.append(separator);
                sb.append(errorItem.content);
                sb.append(separator);
                for (String message : errorItem.errors) {
                    sb.append(message);
                    sb.append(separator);
                }
                LOGGER.error(sb.toString());
            }
            eventHandler.clear();
        }
    }

    private Document marshallToDocument(Object data) throws ParserConfigurationException, JAXBException, TransformerException {
        Document document = this.documentBuilderFactory.newDocumentBuilder().newDocument();
        this.marshaller.marshal(data, (Node)document);
        return document;
    }

    private Transformer buildTransformer() throws TransformerConfigurationException {
        Transformer transformer = this.transformerFactory.newTransformer();
        transformer.setOutputProperty("indent", this.prettyPrint ? "yes" : "no");
        StringBuilder cdataSectElement = new StringBuilder();
        for (String element : this.cdataElements) {
            cdataSectElement.append("{" + this.schema.getNamespace() + "}" + element + " ");
        }
        transformer.setOutputProperty("cdata-section-elements", cdataSectElement.toString());
        return transformer;
    }

    private String marshalNoValidation(Object data) throws JAXBException {
        StringWriter writer = new StringWriter();
        this.marshalNoValidation(data, (OutputStream)new WriterOutputStream((Writer)writer, "UTF-8"));
        return writer.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void marshalNoValidation(Object data, OutputStream stream) throws JAXBException {
        try {
            Schema schema = this.marshaller.getSchema();
            this.marshaller.setSchema(null);
            this.marshaller.marshal(data, stream);
            this.marshaller.setSchema(schema);
        }
        finally {
            this.close(stream);
        }
    }

    private void close(Closeable closeable) {
        if (null != closeable) {
            try {
                closeable.close();
            }
            catch (IOException e) {
                LOGGER.error("error during close", (Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void marshalNoValidation(Object data, Writer writer) throws JAXBException {
        try {
            Schema schema = this.marshaller.getSchema();
            this.marshaller.setSchema(null);
            this.marshaller.marshal(data, writer);
            this.marshaller.setSchema(schema);
        }
        finally {
            this.close(writer);
        }
    }

    public <T> String marshallNonRoot(Object data) throws JAXBException {
        JAXBElement<Object> element = this.getJAXBElement(data);
        return this.marshalNoValidation(element);
    }

    public <T, E extends T> String marshallNonRoot(E data, Class<T> clazz) throws JAXBException {
        JAXBElement<T> element = this.getJAXBElement(data, clazz);
        return this.marshalNoValidation(element);
    }

    public <T> void marshallNonRoot(T data, OutputStream out) throws JAXBException {
        JAXBElement<T> element = this.getJAXBElement(data);
        this.marshalNoValidation(element, out);
    }

    public <T> T unmarshall(Source source, Class<T> clazz) throws JAXBException {
        JAXBElement unmarshal = this.unmarshaller.unmarshal(source, clazz);
        this.logValidationMessages(this.unmarshallingEventHandler);
        return (T)unmarshal.getValue();
    }

    public <T> T unmarshall(File f, Class<T> clazz) throws JAXBException {
        return this.unmarshall(new StreamSource(f), clazz);
    }

    public <T> T unmarshall(InputStream is, Class<T> clazz) throws JAXBException {
        return this.unmarshall(new StreamSource(is), clazz);
    }

    public <T> T unmarshall(String data, Class<T> clazz) throws JAXBException {
        return this.unmarshall(new StreamSource(new StringReader(data)), clazz);
    }

    private Object unmarshall(Source source) throws JAXBException {
        Object object = this.unmarshaller.unmarshal(source);
        this.logValidationMessages(this.unmarshallingEventHandler);
        if (object instanceof JAXBElement) {
            return ((JAXBElement)object).getValue();
        }
        return object;
    }

    public Object unmarshall(File f) throws JAXBException {
        return this.unmarshall(new StreamSource(f));
    }

    public Object unmarshall(InputStream is) throws JAXBException {
        return this.unmarshall(new StreamSource(is));
    }

    public Object unmarshall(String data) throws JAXBException {
        return this.unmarshall(new StreamSource(new StringReader(data)));
    }

    public Object unmarshall(InputSource inputSource) throws JAXBException {
        Object object = this.unmarshaller.unmarshal(inputSource);
        this.logValidationMessages(this.unmarshallingEventHandler);
        return object;
    }

    private <T> JAXBElement<T> getJAXBElement(T data) {
        Class<?> clazz = data.getClass();
        return this.getJAXBElement(data, clazz);
    }

    private <T, E extends T> JAXBElement<T> getJAXBElement(E data, Class<T> clazz) {
        String simpleName = clazz.getSimpleName();
        String type = simpleName.substring(0, 1).toLowerCase() + simpleName.substring(1);
        QName qName = new QName(this.schema.getNamespace(), type);
        JAXBElement element = new JAXBElement(qName, clazz, data);
        return element;
    }

    public static MarshallService getMarshallService() throws JAXBException {
        MarshallService marshallService = new MarshallService();
        marshallService.setSchema(AppNGSchema.PLATFORM);
        marshallService.setPrettyPrint(true);
        marshallService.init();
        return marshallService;
    }

    public String getSchemaLocation() {
        return this.schemaLocation;
    }

    public void setSchemaLocation(String schemaLocation) {
        this.schemaLocation = schemaLocation;
    }

    public DocumentBuilderFactory getDocumentBuilderFactory() {
        return this.documentBuilderFactory;
    }

    public void setDocumentBuilderFactory(DocumentBuilderFactory documentBuilderFactory) {
        this.documentBuilderFactory = documentBuilderFactory;
    }

    public TransformerFactory getTransformerFactory() {
        return this.transformerFactory;
    }

    public void setTransformerFactory(TransformerFactory transformerFactory) {
        this.transformerFactory = transformerFactory;
    }

    public List<String> getCdataElements() {
        return this.cdataElements;
    }

    public void setCdataElements(List<String> cdataElements) {
        this.cdataElements = cdataElements;
    }

    public boolean isThrowMarshallingError() {
        return this.throwMarshallingError;
    }

    public void setThrowMarshallingError(boolean throwMarshallingError) {
        this.throwMarshallingError = throwMarshallingError;
    }

    public boolean isThrowUnmarshallingError() {
        return this.throwUnmarshallingError;
    }

    public void setThrowUnmarshallingError(boolean throwUnmarshallingError) {
        this.throwUnmarshallingError = throwUnmarshallingError;
    }

    class MarshallEventHandler
    implements ValidationEventHandler {
        private MarshallService inner;
        private Map<Integer, ErrorItem> errorItems;
        private boolean throwError;

        MarshallEventHandler(boolean throwError) throws JAXBException {
            this.inner = new MarshallService(MarshallService.this.schema);
            this.throwError = throwError;
            this.errorItems = new HashMap<Integer, ErrorItem>();
        }

        public void clear() {
            this.errorItems.clear();
        }

        public Map<Integer, ErrorItem> getErrorItems() {
            return this.errorItems;
        }

        public boolean handleEvent(ValidationEvent event) {
            ValidationEventLocator locator = event.getLocator();
            if (this.throwError) {
                return event.getSeverity() < 1;
            }
            Object object = locator.getObject();
            int lineNumber = locator.getLineNumber();
            int columnNumber = locator.getColumnNumber();
            if (null != object) {
                ByteArrayOutputStream out = new ByteArrayOutputStream();
                try {
                    ErrorItem errorItem;
                    this.inner.marshallNonRoot(object, out);
                    int id = object.hashCode();
                    if (!this.errorItems.containsKey(id)) {
                        this.errorItems.put(id, new ErrorItem(object, out.toString()));
                    }
                    if (null != (errorItem = this.errorItems.get(id))) {
                        String message = "";
                        if (lineNumber > -1 && columnNumber > -1) {
                            message = message + "line " + lineNumber + ", column " + columnNumber;
                        }
                        message = message + event.getMessage();
                        errorItem.addError(message);
                    }
                }
                catch (JAXBException e) {
                    LOGGER.warn("error while marshalling object {}", object);
                }
            } else {
                String message = "";
                if (lineNumber > -1 && columnNumber > -1) {
                    message = message + "error on line " + lineNumber + ", column " + columnNumber + ": ";
                }
                message = message + event.getMessage();
                LOGGER.error(message);
            }
            return true;
        }
    }

    class ErrorItem {
        private Object object;
        private List<String> errors;
        private String content;

        ErrorItem(Object object, String content) {
            this.object = object;
            this.content = content;
            this.errors = new ArrayList<String>();
        }

        void addError(String error) {
            this.errors.add(error);
        }
    }

    public static enum AppNGSchema {
        PLATFORM("org.appng.xml.platform", "http://www.appng.org/schema/platform", "appng-platform.xsd"),
        APPLICATION("org.appng.xml.application", "http://www.appng.org/schema/application", "appng-application.xsd");

        private final String xsd;
        private final String namespace;
        private final JAXBContext context;

        private AppNGSchema(String contextPath, String namespace, String xsd) {
            this.xsd = xsd;
            this.namespace = namespace;
            try {
                this.context = JAXBContext.newInstance((String)contextPath);
            }
            catch (JAXBException e) {
                throw new IllegalStateException("error while creating JAXBContext for path '" + contextPath + "'");
            }
        }

        public String getXsd() {
            return this.xsd;
        }

        public String getNamespace() {
            return this.namespace;
        }

        public JAXBContext getContext() {
            return this.context;
        }
    }
}

