/*
 * Decompiled with CFR 0.152.
 */
package org.appng.xml.transformation;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Map;
import java.util.TreeMap;
import java.util.TreeSet;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Comment;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class StyleSheetProvider {
    private static final Logger log = LoggerFactory.getLogger(StyleSheetProvider.class);
    private static final String XSL_INCLUDE = "xsl:include";
    private InputStream masterSource;
    private DocumentBuilderFactory documentBuilderFactory;
    private TransformerFactory transformerFactory;
    private DocumentBuilder documentBuilder;
    private Transformer transformer;
    private String insertBefore;
    private Map<String, InputStream> styleReferences = new TreeMap<String, InputStream>();
    private String name;
    private String templateRoot;

    public void init() {
        try {
            this.documentBuilder = this.getDocumentBuilderFactory().newDocumentBuilder();
            this.transformer = this.getTransformerFactory().newTransformer();
        }
        catch (Exception e) {
            log.error("[" + this.name + "] error setting up StyleSheetProvider, instance will not work!", (Throwable)e);
        }
    }

    public void setMasterSource(InputStream masterXsl, String templateRoot) {
        try {
            this.masterSource = masterXsl;
            this.templateRoot = templateRoot;
        }
        catch (Exception e) {
            log.error("[" + this.name + "] error setting up StyleSheetProvider, instance will not work!", (Throwable)e);
        }
    }

    public void addStyleSheet(InputStream styleSheet, String reference) {
        try {
            if (this.styleReferences.containsKey(reference)) {
                log.warn("[" + this.name + "] stylesheet '" + reference + "' is already defined, contents will be overridden!");
            }
            this.styleReferences.put(reference, styleSheet);
            log.trace("[" + this.name + "] adding stylesheet with reference '" + reference + "'");
        }
        catch (Exception e) {
            log.error("[" + this.name + "] error parsing stylesheet '" + reference + "'", (Throwable)e);
        }
    }

    public byte[] getStyleSheet(boolean deleteIncludes) {
        return this.getStyleSheet(deleteIncludes, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] getStyleSheet(boolean deleteIncludes, OutputStream additionalOut) {
        try {
            Document masterDoc = this.documentBuilder.parse(this.masterSource);
            Node rootNode = masterDoc.getFirstChild();
            Node insertionPoint = null;
            NodeList nodes = rootNode.getChildNodes();
            ArrayList<Node> includes = new ArrayList<Node>();
            int hits = nodes.getLength();
            for (int i = 0; i < hits; ++i) {
                Node node = nodes.item(i);
                String nodeName = node.getNodeName();
                if (XSL_INCLUDE.equals(nodeName)) {
                    includes.add(node);
                    continue;
                }
                if (!this.insertBefore.equals(nodeName)) continue;
                insertionPoint = node;
            }
            for (Node node : includes) {
                Node href = node.getAttributes().getNamedItem("href");
                String reference = href.getTextContent();
                rootNode.removeChild(node);
                if (deleteIncludes) {
                    log.trace("[" + this.name + "] removing reference to '" + reference + "'");
                    continue;
                }
                File file = new File(this.templateRoot, reference);
                this.styleReferences.put(reference, new FileInputStream(file));
            }
            for (String reference : this.styleReferences.keySet()) {
                this.includeStyleSheet(rootNode, insertionPoint, reference);
            }
            ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
            DOMSource domSource = new DOMSource(masterDoc);
            if (additionalOut != null) {
                this.transformer.transform(domSource, new StreamResult(additionalOut));
            }
            this.transformer.transform(domSource, new StreamResult(outputStream));
            log.debug("stylesheet complete");
            byte[] byArray = outputStream.toByteArray();
            return byArray;
        }
        catch (Exception e) {
            log.error("[" + this.name + "] error writing stylesheet", (Throwable)e);
        }
        finally {
            this.close(this.masterSource);
        }
        return null;
    }

    protected void close(InputStream is) {
        try {
            is.close();
        }
        catch (IOException e) {
            log.error("error closing stream", (Throwable)e);
        }
        finally {
            is = null;
        }
    }

    private void includeStyleSheet(Node rootNode, Node insertionPoint, String reference) throws SAXException, IOException {
        InputStream inputStream = this.styleReferences.get(reference);
        Document styleSheetDoc = this.getDocumentBuilder().parse(inputStream);
        if (null == styleSheetDoc) {
            log.warn("[" + this.name + "] referenced stylesheet '" + reference + "' could not be found, inclusion skipped!");
        } else {
            log.trace("[" + this.name + "] including referenced stylesheet '" + reference + "'");
            NodeList childNodes = styleSheetDoc.getFirstChild().getChildNodes();
            Document ownerDocument = rootNode.getOwnerDocument();
            Comment beginComment = ownerDocument.createComment("[BEGIN] embed '" + reference + "'");
            Comment endComment = ownerDocument.createComment("[END] embed '" + reference + "'");
            Node inserted = rootNode.insertBefore(endComment, insertionPoint);
            for (int i = 0; i < childNodes.getLength(); ++i) {
                Node sourceNode = childNodes.item(i);
                Node adoptedNode = ownerDocument.importNode(sourceNode, true);
                inserted = rootNode.insertBefore(adoptedNode, inserted);
            }
            inserted = rootNode.insertBefore(beginComment, inserted);
        }
    }

    public DocumentBuilderFactory getDocumentBuilderFactory() {
        return this.documentBuilderFactory;
    }

    public void setDocumentBuilderFactory(DocumentBuilderFactory documentBuilderFactory) {
        this.documentBuilderFactory = documentBuilderFactory;
    }

    public TransformerFactory getTransformerFactory() {
        return this.transformerFactory;
    }

    public void setTransformerFactory(TransformerFactory transformerFactory) {
        this.transformerFactory = transformerFactory;
    }

    public DocumentBuilder getDocumentBuilder() {
        return this.documentBuilder;
    }

    public void setDocumentBuilder(DocumentBuilder documentBuilder) {
        this.documentBuilder = documentBuilder;
    }

    public Transformer getTransformer() {
        return this.transformer;
    }

    public void setTransformer(Transformer transformer) {
        this.transformer = transformer;
    }

    public String getInsertBefore() {
        return this.insertBefore;
    }

    public void setInsertBefore(String insertBefore) {
        this.insertBefore = insertBefore;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getId() {
        return StringUtils.join(new TreeSet<String>(this.styleReferences.keySet()), (String)",");
    }

    public void cleanup() {
        new ArrayList<String>(this.styleReferences.keySet()).forEach(k -> this.close(this.styleReferences.remove(k)));
    }

    public boolean isValid() {
        return null != this.masterSource;
    }
}

