/*
 * Decompiled with CFR 0.152.
 */
package org.appng.xml;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Properties;
import javax.xml.bind.JAXBException;
import org.apache.commons.lang3.StringUtils;
import org.appng.xml.MarshallService;
import org.appng.xml.application.ApplicationInfo;
import org.appng.xml.application.Property;

public class ApplicationPropertyConstantCreator {
    public static void main(String[] args) throws IOException, JAXBException {
        String prefix;
        if (args.length < 3) {
            throw new IllegalArgumentException("need 3 params (filePath, targetClass, outFolder)");
        }
        String filePath = args[0];
        String targetClass = args[1];
        String outfolder = args[2];
        String string = prefix = args.length == 4 ? args[3] : "";
        if (!targetClass.matches("([a-zA-Z]+[0-9]*)+(\\.[a-zA-Z]+[0-9]*)*")) {
            throw new IllegalArgumentException("not a valid classname: " + targetClass);
        }
        File file = new File(filePath);
        Properties props = new Properties();
        props.load(new FileInputStream(file));
        ApplicationInfo application = MarshallService.getApplicationMarshallService().unmarshall(file, ApplicationInfo.class);
        List<Property> properties = application.getProperties().getProperty();
        Collections.sort(properties, new Comparator<Property>(){

            @Override
            public int compare(Property o1, Property o2) {
                return o1.getId().compareToIgnoreCase(o2.getId());
            }
        });
        String separator = System.getProperty("line.separator");
        int pckg = targetClass.lastIndexOf(".");
        StringBuilder sb = new StringBuilder();
        sb.append("package " + targetClass.substring(0, pckg) + ";" + separator);
        sb.append(separator);
        sb.append("/** Property constants for " + application.getName() + " " + application.getVersion() + " */");
        sb.append(separator);
        sb.append("public class " + targetClass.substring(pckg + 1) + " {" + separator);
        sb.append(separator);
        for (Property property : properties) {
            if (StringUtils.isNotBlank((CharSequence)property.getDescription())) {
                sb.append("\t/** " + property.getDescription() + " */" + separator);
            }
            sb.append("\tpublic static final String ");
            sb.append(prefix);
            String[] tokens = StringUtils.splitByCharacterTypeCamelCase((String)property.getId());
            for (int i = 0; i < tokens.length; ++i) {
                String s = tokens[i];
                if ("_".equals(s)) continue;
                if (i > 0) {
                    sb.append("_");
                }
                sb.append(s.toUpperCase());
            }
            sb.append(" = \"" + property.getId() + "\";" + separator);
        }
        sb.append(separator);
        sb.append("}");
        String fileName = targetClass.replaceAll("\\.", "/") + ".java";
        File outFile = new File(new File(outfolder).getAbsoluteFile(), fileName);
        outFile.getParentFile().mkdirs();
        FileOutputStream fos = new FileOutputStream(outFile);
        fos.write(sb.toString().getBytes());
        fos.close();
    }
}

