/*
 * Decompiled with CFR 0.152.
 */
package org.appng.tools.poi;

import org.apache.poi.ss.usermodel.BorderStyle;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;

public class Border {
    public static final Border BOTTOM_THICK = new Border(BorderLocation.BOTTOM, BorderStyle.THICK);
    public static final Border BOTTOM_THIN = new Border(BorderLocation.BOTTOM, BorderStyle.THIN);
    public static final Border BOTTOM_DASHED = new Border(BorderLocation.BOTTOM, BorderStyle.DASHED);
    public static final Border BOTTOM_DOUBLE = new Border(BorderLocation.BOTTOM, BorderStyle.DOUBLE);
    public static final Border BOTTOM_DOTTED = new Border(BorderLocation.BOTTOM, BorderStyle.DOTTED);
    public static final Border TOP_THICK = new Border(BorderLocation.TOP, BorderStyle.THICK);
    public static final Border TOP_THIN = new Border(BorderLocation.TOP, BorderStyle.THIN);
    public static final Border TOP_DASHED = new Border(BorderLocation.TOP, BorderStyle.DASHED);
    public static final Border TOP_DOUBLE = new Border(BorderLocation.TOP, BorderStyle.DOUBLE);
    public static final Border TOP_DOTTED = new Border(BorderLocation.TOP, BorderStyle.DOTTED);
    public static final Border RIGHT_THICK = new Border(BorderLocation.RIGHT, BorderStyle.THICK);
    public static final Border RIGHT_THIN = new Border(BorderLocation.RIGHT, BorderStyle.THIN);
    public static final Border RIGHT_DASHED = new Border(BorderLocation.RIGHT, BorderStyle.DASHED);
    public static final Border RIGHT_DOUBLE = new Border(BorderLocation.RIGHT, BorderStyle.DOUBLE);
    public static final Border RIGHT_DOTTED = new Border(BorderLocation.RIGHT, BorderStyle.DOTTED);
    public static final Border LEFT_THICK = new Border(BorderLocation.LEFT, BorderStyle.THICK);
    public static final Border LEFT_THIN = new Border(BorderLocation.LEFT, BorderStyle.THIN);
    public static final Border LEFT_DASHED = new Border(BorderLocation.LEFT, BorderStyle.DASHED);
    public static final Border LEFT_DOUBLE = new Border(BorderLocation.LEFT, BorderStyle.DOUBLE);
    public static final Border LEFT_DOTTED = new Border(BorderLocation.LEFT, BorderStyle.DOTTED);
    private final BorderLocation location;
    private final BorderStyle style;

    public Border(BorderLocation location, BorderStyle style) {
        this.location = location;
        this.style = style;
    }

    public void applyTo(CellStyle cellStyle) {
        switch (this.location) {
            case BOTTOM: {
                cellStyle.setBorderBottom(this.style);
                break;
            }
            case TOP: {
                cellStyle.setBorderTop(this.style);
                break;
            }
            case LEFT: {
                cellStyle.setBorderLeft(this.style);
                break;
            }
            case RIGHT: {
                cellStyle.setBorderRight(this.style);
            }
        }
    }

    public void applyTo(Cell cell) {
        this.applyTo(cell.getCellStyle());
    }

    public String toString() {
        return this.location.name() + ": " + this.style.name();
    }

    public static enum BorderLocation {
        BOTTOM,
        LEFT,
        RIGHT,
        TOP;

    }
}

