/*
 * Decompiled with CFR 0.152.
 */
package org.appng.tools.os;

import java.io.IOException;
import java.io.InputStream;
import org.appng.tools.os.OperatingSystem;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Command {
    private static final Logger LOGGER = LoggerFactory.getLogger(Command.class);
    public static final int ERROR = -1;
    public static final int WRONG_OS = -2;

    public static int execute(String command, StreamConsumer<?> outputConsumer, StreamConsumer<?> errorConsumer) {
        try {
            LOGGER.debug("executing: '{}'", (Object)command);
            Process process = Runtime.getRuntime().exec(command);
            if (null != outputConsumer) {
                outputConsumer.consume(process.getInputStream());
            }
            if (null != errorConsumer) {
                errorConsumer.consume(process.getErrorStream());
            }
            return process.waitFor();
        }
        catch (Exception e) {
            LOGGER.warn(String.format("error while executing: %s", command), (Throwable)e);
            return -1;
        }
    }

    public static int execute(OperatingSystem os, String command, StreamConsumer<?> outputConsumer, StreamConsumer<?> errorConsumer) {
        if (OperatingSystem.isOs(os)) {
            return Command.execute(command, outputConsumer, errorConsumer);
        }
        return -2;
    }

    public static interface StreamConsumer<T> {
        public void consume(InputStream var1) throws IOException;

        public T getResult();
    }
}

