/*
 * Decompiled with CFR 0.152.
 */
package org.appng.tools.markup;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class XHTML {
    public static String removeAttr(String tag, String attr) {
        String pattern = XHTML.getAttributeExpression(attr);
        Pattern p = Pattern.compile(pattern);
        Matcher m = p.matcher(tag);
        if (m.find()) {
            tag = tag.replaceAll(pattern, "");
        }
        return tag;
    }

    public static String setAttr(String tag, String attr, String value) {
        Pattern p = Pattern.compile(XHTML.getAttributeExpression(attr));
        Matcher m = p.matcher(tag);
        if (m.find()) {
            tag = tag.replaceFirst(XHTML.getAttributeExpression(attr), " " + attr + "=\"" + value + "\"");
        } else {
            p = Pattern.compile("(<\\w+?)([\\s|>])");
            m = p.matcher(tag);
            if (m.find()) {
                String suffix = m.group(2).equals(">") ? ">" : " ";
                tag = m.replaceFirst(m.group(1) + " " + attr + "=\"" + value + "\"" + suffix);
            }
        }
        return tag;
    }

    private static String getAttributeExpression(String attr) {
        return " " + attr + "=\"(.*?)\"";
    }

    public static String getBody(String tag, String content) {
        String regex = "(<" + tag + "(.)*>)(.*)(</( )?" + tag + ">)";
        Pattern pattern = Pattern.compile(regex);
        Matcher matcher = pattern.matcher(content);
        if (matcher.matches() && matcher.groupCount() > 2) {
            String body = matcher.group(3);
            return body;
        }
        return null;
    }

    public static String setBody(String tag, String value) {
        String name = XHTML.getTag(tag);
        tag = tag.replaceFirst(">.*?</" + name + ">", ">" + value + "</" + name + ">");
        return tag;
    }

    public static String getAttr(String tag, String attr) {
        String value = "";
        Pattern p = Pattern.compile(XHTML.getAttributeExpression(attr));
        Matcher m = p.matcher(tag);
        if (m.find()) {
            value = m.group(1);
        }
        return value;
    }

    public static String getTag(String tag) {
        String value = "";
        Pattern p = Pattern.compile("<(\\w+?)\\s");
        Matcher m = p.matcher(tag);
        if (m.find()) {
            value = m.group(1);
        }
        return value;
    }
}

