/*
 * Decompiled with CFR 0.152.
 */
package org.appng.tools.file;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Properties;
import java.util.Set;
import java.util.TreeSet;
import org.apache.commons.lang3.StringUtils;

public class PropertyConstantCreator {
    public static void main(String[] args) throws IOException {
        if (args.length != 3) {
            throw new IllegalArgumentException("need 3 params (filePath, targetClass, outFolder)");
        }
        String filePath = args[0];
        String targetClass = args[1];
        String outfolder = args[2];
        if (!targetClass.matches("([a-zA-Z]+[0-9]*)+(\\.[a-zA-Z]+[0-9]*)*")) {
            throw new IllegalArgumentException("not a valid classname: " + targetClass);
        }
        File file = new File(filePath);
        Properties props = new Properties();
        props.load(new FileInputStream(file));
        int pckg = targetClass.lastIndexOf(".");
        StringBuilder sb = new StringBuilder();
        sb.append("package " + targetClass.substring(0, pckg) + ";\r\n");
        sb.append("\r\n");
        sb.append("public class " + targetClass.substring(pckg + 1) + " {\r\n");
        sb.append("\r\n");
        Set<Object> keySet = props.keySet();
        TreeSet<Object> sorted = new TreeSet<Object>(keySet);
        for (Object e : sorted) {
            String key = (String)e;
            sb.append("\t/** " + props.getProperty(key).replace("*/", "*&#47;") + " */\r\n");
            sb.append("\tpublic static final String ");
            String constantName = key.replaceAll("\\.", "_").replaceAll("-", "_");
            String[] tokens = StringUtils.splitByCharacterTypeCamelCase((String)constantName);
            for (int i = 0; i < tokens.length; ++i) {
                String s = tokens[i];
                if ("_".equals(s)) continue;
                if (i > 0) {
                    sb.append("_");
                }
                sb.append(s.toUpperCase());
            }
            sb.append(" = \"" + key + "\";\r\n");
        }
        sb.append("\r\n");
        sb.append("}");
        String fileName = targetClass.replaceAll("\\.", "/") + ".java";
        File file2 = new File(new File(outfolder).getAbsoluteFile(), fileName);
        file2.getParentFile().mkdirs();
        FileOutputStream fos = new FileOutputStream(file2);
        fos.write(sb.toString().getBytes());
        fos.close();
    }
}

