/*
 * Decompiled with CFR 0.152.
 */
package org.appng.tools.locator;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLEncoder;
import java.security.GeneralSecurityException;
import java.util.Properties;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.codec.digest.HmacUtils;
import org.apache.commons.lang3.StringUtils;
import org.appng.tools.locator.Coordinate;
import org.appng.tools.locator.GeoLocator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GMapGeoLocator
implements GeoLocator {
    private static final Logger logger = LoggerFactory.getLogger(GMapGeoLocator.class);
    public static final String GOOGLE_URI = "googleUri";
    public static final String GOOGLE_SUFFIX = "googleSuffix";
    public static final String GOOGLE_CLIENT_ID = "googleClientId";
    public static final String GOOGLE_SIGNING_KEY = "googleSigningKey";
    public static final String SLEEP_TIME = "sleepTime";
    private static final String ENCODING = "UTF-8";
    private static final String DEFAULT_URI = "https://maps.google.com/maps/api/geocode/json";
    private static final String DEFAULT_SUFFIX = "&sensor=false";
    private static final String DEFAULT_SLEEP_TIME = "100";
    private static final String STATUS = "status";
    private static final String OK = "OK";
    private static final String RESULTS = "results";
    private static final String GEOMETRY = "geometry";
    private static final String LOCATION = "location";
    private static final String FORMATTED_ADDRESS = "formatted_address";
    private static final String LAT = "lat";
    private static final String LNG = "lng";
    private String uri = "https://maps.google.com/maps/api/geocode/json";
    private String suffix = "&sensor=false";
    private String clientId;
    private String signingKey;
    private Long sleepTime = 100L;

    @Override
    public void configure(Properties properties) {
        if (null != properties) {
            this.uri = properties.getProperty(GOOGLE_URI, DEFAULT_URI);
            this.suffix = properties.getProperty(GOOGLE_SUFFIX, DEFAULT_SUFFIX);
            this.clientId = properties.getProperty(GOOGLE_CLIENT_ID);
            this.signingKey = properties.getProperty(GOOGLE_SIGNING_KEY);
            this.sleepTime = Long.valueOf(properties.getProperty(SLEEP_TIME, DEFAULT_SLEEP_TIME));
        }
    }

    @Override
    public Coordinate locate(String zip, String city, String street) {
        return this.locate(zip, city, street, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Coordinate locate(String zip, String city, String street, String country) {
        HttpURLConnection connection = null;
        try {
            JsonNode status;
            StringBuilder query = new StringBuilder();
            boolean space = this.append(query, street, false);
            space = this.append(query, zip, space);
            space = this.append(query, city, space);
            this.append(query, country, space);
            String requestUrl = this.uri + "?address=" + URLEncoder.encode(query.toString(), ENCODING) + this.suffix;
            if (StringUtils.isNotBlank((CharSequence)this.clientId)) {
                requestUrl = requestUrl + "&client=" + this.clientId;
            }
            JsonNode response = this.getJsonResponse(this.buildUrl(requestUrl));
            if (logger.isTraceEnabled()) {
                logger.trace(requestUrl);
                logger.trace(response.toString());
            }
            if (OK.equalsIgnoreCase((status = response.get(STATUS)).textValue())) {
                JsonNode result = response.get(RESULTS).get(0);
                JsonNode location = result.get(GEOMETRY).get(LOCATION);
                String address = result.get(FORMATTED_ADDRESS).textValue();
                double lat = location.get(LAT).doubleValue();
                double lng = location.get(LNG).doubleValue();
                Coordinate coordinate = new Coordinate(lat, lng);
                logger.debug("found coordinates for address '" + address + "': " + coordinate);
                Coordinate coordinate2 = coordinate;
                return coordinate2;
            }
            logger.debug("return-code was '" + status.textValue() + "' for request '" + requestUrl + "', no coordinates retrieved");
        }
        catch (Exception e) {
            logger.warn("error while retrieving coordinates", (Throwable)e);
        }
        finally {
            if (null != connection) {
                connection.disconnect();
            }
        }
        return null;
    }

    protected boolean append(StringBuilder query, String street, boolean addSpace) {
        boolean hasValue = StringUtils.isNotBlank((CharSequence)street);
        if (hasValue) {
            if (addSpace) {
                query.append(" ");
            }
            query.append(street);
        }
        return hasValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected JsonNode getJsonResponse(URL url) throws IOException, InterruptedException, GeneralSecurityException {
        HttpURLConnection connection = null;
        try {
            connection = (HttpURLConnection)url.openConnection();
            Thread.sleep(this.sleepTime);
            connection.connect();
            InputStream is = connection.getInputStream();
            JsonNode jsonNode = new ObjectMapper().reader().readTree(is);
            return jsonNode;
        }
        finally {
            if (null != connection) {
                connection.disconnect();
            }
        }
    }

    protected URL buildUrl(String requestUrl) throws MalformedURLException, GeneralSecurityException, IOException {
        URL url = new URL(requestUrl);
        if (StringUtils.isNotBlank((CharSequence)this.clientId) && StringUtils.isNotBlank((CharSequence)this.signingKey)) {
            String signedRequest = new UrlSigner(this.signingKey).signRequest(url.getPath(), url.getQuery());
            url = new URL(url.getProtocol() + "://" + url.getHost() + signedRequest);
        }
        return url;
    }

    class UrlSigner {
        private byte[] key;

        public UrlSigner(String keyString) throws IOException {
            keyString = keyString.replace('-', '+');
            keyString = keyString.replace('_', '/');
            this.key = Base64.decodeBase64((String)keyString);
        }

        public String signRequest(String path, String query) throws GeneralSecurityException {
            String resource = path + '?' + query;
            byte[] sigBytes = HmacUtils.getHmacSha1((byte[])this.key).doFinal(resource.getBytes());
            String signature = Base64.encodeBase64URLSafeString((byte[])sigBytes);
            return resource + "&signature=" + signature;
        }
    }
}

