/*
 * Decompiled with CFR 0.152.
 */
package org.appng.tools.file;

import java.io.File;
import net.sf.jmimemagic.Magic;
import net.sf.jmimemagic.MagicException;
import net.sf.jmimemagic.MagicMatchNotFoundException;
import net.sf.jmimemagic.MagicParseException;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.time.StopWatch;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MagicByteCheck {
    private static Logger LOG = LoggerFactory.getLogger(MagicByteCheck.class);

    public static boolean compareFileExtensionWithMagicBytes(File sourceFile) {
        StopWatch sw = new StopWatch();
        sw.start();
        String magicExtension = MagicByteCheck.getExtensionByMagicBytes(sourceFile);
        String fileNameExtension = MagicByteCheck.normalizeFileExtension(FilenameUtils.getExtension((String)sourceFile.getName()));
        boolean matches = magicExtension.equalsIgnoreCase(fileNameExtension);
        if (!matches) {
            LOG.debug("File type detected by magic byte ({}) is not identical with file extension for file {}", new Object[]{magicExtension, fileNameExtension, sourceFile.getAbsolutePath()});
        }
        sw.stop();
        LOG.trace(sw.toString());
        return matches;
    }

    public static String getExtensionByMagicBytes(File file) {
        try {
            return MagicByteCheck.normalizeFileExtension(Magic.getMagicMatch((File)file, (boolean)false).getExtension());
        }
        catch (MagicException | MagicMatchNotFoundException | MagicParseException e) {
            LOG.error("Magic Exception for file " + file.getAbsolutePath(), e);
            throw new IllegalArgumentException(e);
        }
    }

    private static String normalizeFileExtension(String extension) {
        return extension.equalsIgnoreCase("jpeg") ? "jpg" : extension;
    }
}

