/*
 * Decompiled with CFR 0.152.
 */
package org.appng.testsupport.validation;

import java.util.HashMap;
import java.util.Map;
import org.appng.testsupport.validation.DifferenceHandler;
import org.custommonkey.xmlunit.Difference;
import org.custommonkey.xmlunit.DifferenceListener;
import org.custommonkey.xmlunit.NodeDetail;

public class XPathDifferenceHandler
extends DifferenceHandler {
    private static final String POSITON_PATTERN = "\\[\\d+\\]";
    private Map<String, DifferenceListener> handlers = new HashMap<String, DifferenceListener>();
    private boolean stripPositions;

    public XPathDifferenceHandler(boolean stripPositions) {
        this.stripPositions = stripPositions;
    }

    public XPathDifferenceHandler() {
        this(true);
    }

    public void ignoreDifference(String xpath) {
        this.addDifferenceListener(xpath, new DifferenceHandler(){

            @Override
            public int differenceFound(Difference difference) {
                return 1;
            }
        });
    }

    public void addDifferenceListener(String xpath, DifferenceListener differenceListener) {
        this.handlers.put(xpath, differenceListener);
    }

    @Override
    public int differenceFound(Difference difference) {
        DifferenceListener differenceListener;
        NodeDetail controlNodeDetail = difference.getControlNodeDetail();
        String xpathLocation = controlNodeDetail.getXpathLocation();
        if (null == xpathLocation) {
            xpathLocation = difference.getTestNodeDetail().getXpathLocation();
        }
        if (null == (differenceListener = this.handlers.get(xpathLocation)) && this.stripPositions) {
            differenceListener = this.handlers.get(xpathLocation.replaceAll(POSITON_PATTERN, ""));
        }
        if (null != differenceListener) {
            return differenceListener.differenceFound(difference);
        }
        return 0;
    }
}

