/*
 * Decompiled with CFR 0.152.
 */
package org.appng.testsupport.validation;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.StringReader;
import javax.xml.bind.JAXBException;
import javax.xml.parsers.DocumentBuilder;
import org.appng.xml.BaseObject;
import org.appng.xml.MarshallService;
import org.custommonkey.xmlunit.Diff;
import org.custommonkey.xmlunit.DifferenceListener;
import org.custommonkey.xmlunit.XMLAssert;
import org.custommonkey.xmlunit.XMLUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class WritingXmlValidator {
    private static final Logger LOGGER = LoggerFactory.getLogger(WritingXmlValidator.class);
    public static boolean writeXml = false;
    public static boolean logXml = false;
    public static String controlFileSource = "src/test/resources/";

    public static File writeToDisk(Object data, String name) throws IOException {
        File target = new File(controlFileSource + name);
        try (FileOutputStream out = new FileOutputStream(target);){
            try {
                WritingXmlValidator.getMarshallService().marshallNonRoot(data, (OutputStream)out);
            }
            catch (JAXBException e) {
                throw new IOException("error while marshalling " + data, e);
            }
        }
        return target;
    }

    public static File writeToDiskPlain(String data, String name) throws IOException {
        File target = new File(controlFileSource + name);
        try (FileOutputStream out = new FileOutputStream(target);){
            out.write(data.getBytes());
        }
        return target;
    }

    public static void validateXml(BaseObject object, String controlFile) throws IOException {
        WritingXmlValidator.validateXml(object, controlFile, null);
    }

    public static void validateXml(BaseObject object, String controlFile, DifferenceListener differenceListener) throws IOException {
        try {
            String resultXml = WritingXmlValidator.getMarshallService().marshallNonRoot((Object)object);
            if (writeXml) {
                File target = WritingXmlValidator.writeToDisk(object, controlFile);
                WritingXmlValidator.validateXml(resultXml, target, false, differenceListener);
            } else {
                WritingXmlValidator.validateXml(resultXml, controlFile, false, differenceListener);
            }
        }
        catch (JAXBException e) {
            throw new IOException("error while marshalling " + object, e);
        }
    }

    public static void validateXml(String result, String controlFile) throws IOException {
        WritingXmlValidator.validateXml(result, controlFile, null);
    }

    public static void validateXml(String result, String controlFile, DifferenceListener differenceListener) throws IOException {
        if (writeXml) {
            WritingXmlValidator.writeToDiskPlain(result, controlFile);
        }
        InputSource expected = WritingXmlValidator.getControlSource(controlFile);
        WritingXmlValidator.validate(expected, result, differenceListener);
    }

    public static void validateXml(String result, File controlFile, DifferenceListener differenceListener) throws IOException {
        InputSource expected = WritingXmlValidator.getControlSource(controlFile);
        WritingXmlValidator.validate(expected, result, differenceListener);
    }

    public static void validateXml(String result, String controlFile, boolean trimComment) throws IOException {
        WritingXmlValidator.validateXml(result, controlFile, trimComment, null);
    }

    public static void validateXml(String result, String controlFile, boolean trimComment, DifferenceListener differenceListener) throws IOException {
        if (trimComment) {
            result = result.replace("<!--", "").trim();
            result = result.replace("-->", "").trim();
        }
        WritingXmlValidator.validateXml(result, controlFile, differenceListener);
    }

    public static void validateXml(String result, File controlFile, boolean trimComment, DifferenceListener differenceListener) throws IOException {
        if (trimComment) {
            result = result.replace("<!--", "").trim();
            result = result.replace("-->", "").trim();
        }
        WritingXmlValidator.validateXml(result, controlFile, differenceListener);
    }

    private static void validate(InputSource expected, String resultXml, DifferenceListener differenceListener) throws IOException {
        InputSource actual = new InputSource(new StringReader(resultXml));
        Document controlDoc = WritingXmlValidator.getDocument(expected, null);
        Document testDoc = WritingXmlValidator.getDocument(actual, resultXml);
        Diff myDiff = new Diff(controlDoc, testDoc);
        if (null != differenceListener) {
            myDiff.overrideDifferenceListener(differenceListener);
        }
        if (logXml) {
            LOGGER.debug("\r\n{}", (Object)resultXml);
        }
        String message = "XML does not match control XML\r\n" + myDiff.toString() + "\r\n" + resultXml;
        XMLAssert.assertXMLIdentical((String)message, (Diff)myDiff, (boolean)true);
    }

    private static Document getDocument(InputSource source, String input) throws IOException {
        try {
            return XMLUnit.buildDocument((DocumentBuilder)XMLUnit.newControlParser(), (InputSource)source);
        }
        catch (SAXException e) {
            String message = "failed to parse xml";
            if (e instanceof SAXParseException) {
                SAXParseException spe = (SAXParseException)e;
                int lineNumber = spe.getLineNumber();
                int columnNumber = spe.getColumnNumber();
                message = message + " at line " + lineNumber + ", column " + columnNumber;
            }
            if (null != input) {
                message = message + "\r\n" + input;
            }
            throw new IOException(message, e);
        }
    }

    private static InputSource getControlSource(String controlFile) throws IOException {
        InputStream is = WritingXmlValidator.class.getClassLoader().getResourceAsStream(controlFile);
        if (null == is) {
            throw new FileNotFoundException(controlFile);
        }
        return new InputSource(is);
    }

    private static InputSource getControlSource(File controlFile) throws IOException {
        return new InputSource(new FileInputStream(controlFile));
    }

    private static MarshallService getMarshallService() throws JAXBException {
        return MarshallService.getMarshallService();
    }

    static {
        XMLUnit.setNormalizeWhitespace((boolean)true);
        XMLUnit.setIgnoreWhitespace((boolean)true);
    }
}

