/*
 * Decompiled with CFR 0.152.
 */
package org.appng.testsupport.validation;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.MapperFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URISyntaxException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.appng.xml.platform.Action;
import org.appng.xml.platform.Datasource;
import org.junit.Assert;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WritingJsonValidator {
    private static final Logger LOGGER = LoggerFactory.getLogger(WritingJsonValidator.class);
    public static boolean writeJson = false;
    public static boolean logJson = false;
    public static boolean sortPropertiesAlphabetically = false;
    public static String controlFileSource = "src/test/resources/";

    public static File writeToDisk(Object data, String name) throws IOException {
        return WritingJsonValidator.writeToDiskPlain(WritingJsonValidator.toJSON(data), name);
    }

    public static File writeToDiskPlain(String json, String controlFile) throws IOException {
        File target = new File(controlFileSource, controlFile);
        try (FileOutputStream out = new FileOutputStream(target);){
            IOUtils.write((byte[])json.getBytes(), (OutputStream)out);
        }
        return target;
    }

    public static void validate(Action action, String controlFile) throws IOException {
        WritingJsonValidator.validate(new JsonWrapper(action), controlFile);
    }

    public static void validate(Datasource datasource, String controlFile) throws IOException {
        WritingJsonValidator.validate(new JsonWrapper(datasource), controlFile);
    }

    public static void validate(Object object, String controlFile) throws IOException {
        WritingJsonValidator.validate(WritingJsonValidator.toJSON(object), controlFile);
    }

    public static void validate(ObjectMapper objectMapper, Object object, String controlFile) throws IOException {
        String json = WritingJsonValidator.toJSON(objectMapper, object);
        if (writeJson) {
            WritingJsonValidator.writeToDiskPlain(json, controlFile);
        }
        String expected = FileUtils.readFileToString((File)WritingJsonValidator.getControlFile(controlFile), (Charset)StandardCharsets.UTF_8);
        Assert.assertEquals((Object)WritingJsonValidator.normalizeLines(expected), (Object)json);
    }

    public static void validate(String json, String controlFile) throws IOException {
        if (writeJson) {
            WritingJsonValidator.writeToDiskPlain(json, controlFile);
        }
        String expected = FileUtils.readFileToString((File)WritingJsonValidator.getControlFile(controlFile), (Charset)StandardCharsets.UTF_8);
        Assert.assertEquals((Object)WritingJsonValidator.normalizeLines(expected), (Object)json);
    }

    public static String normalizeLines(String string) {
        return string.replaceAll("\\n|\\r\\n", System.lineSeparator());
    }

    public static File getControlFile(String controlFile) throws IOException {
        try {
            return new File(WritingJsonValidator.class.getClassLoader().getResource(controlFile).toURI());
        }
        catch (URISyntaxException e) {
            throw new IOException(e);
        }
    }

    public static String toJSON(Object object) throws IOException {
        ObjectMapper objectMapper = new ObjectMapper().setSerializationInclusion(JsonInclude.Include.NON_EMPTY).configure(MapperFeature.SORT_PROPERTIES_ALPHABETICALLY, sortPropertiesAlphabetically);
        return WritingJsonValidator.toJSON(objectMapper, object);
    }

    public static String toJSON(ObjectMapper objectMapper, Object object) throws IOException {
        StringWriter jsonWriter = new StringWriter();
        objectMapper.writer().withDefaultPrettyPrinter().writeValue((Writer)jsonWriter, object);
        String json = jsonWriter.toString();
        if (logJson) {
            LOGGER.debug(json);
        }
        return json;
    }

    public static class JsonWrapper {
        Action action;
        Datasource datasource;

        JsonWrapper(Action action) {
            this.action = action;
        }

        JsonWrapper(Datasource datasource) {
            this.datasource = datasource;
        }

        public Action getAction() {
            return this.action;
        }

        public Datasource getDatasource() {
            return this.datasource;
        }
    }
}

