/*
 * Decompiled with CFR 0.152.
 */
package org.appng.testsupport.persistence;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.sql.Statement;
import org.hsqldb.Server;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HsqlServer {
    private static final Logger LOGGER = LoggerFactory.getLogger(HsqlServer.class);
    public static final int DEFAULT_PORT = 9001;
    private static final String HSQL_TESTDB = "hsql-testdb";
    private static volatile int startCount = 0;

    public static void main(String[] args) {
        HsqlServer.start(9001);
        HsqlServer.stop(9001);
        HsqlServer.start(9001);
        HsqlServer.stop(9001);
    }

    public static void start() {
        HsqlServer.start(HSQL_TESTDB, 9001);
    }

    public static void start(String dbName) {
        HsqlServer.start(dbName, 9001);
    }

    public static void stop() {
        HsqlServer.stop(HSQL_TESTDB, 9001);
    }

    public static void stop(String dbName) {
        HsqlServer.stop(dbName, 9001);
    }

    public static void start(int port) {
        HsqlServer.start(HSQL_TESTDB, port);
    }

    public static void start(String dbName, int port) {
        HsqlServer.start(dbName, dbName, port);
    }

    public static void start(String dbName, String folder, int port) {
        if (startCount == 0) {
            LOGGER.debug("############# ({}) starting HsqlServer", (Object)startCount);
            String[] params = new String[]{"-database.0", "file:target/hsql/" + folder + "/", "-dbname.0", dbName, "-no_system_exit", "true", "-port", String.valueOf(port)};
            Server.main((String[])params);
        } else {
            LOGGER.debug("############# ({}) HsqlServer already started", (Object)startCount);
        }
        ++startCount;
    }

    public static void stop(int port) {
        HsqlServer.stop(HSQL_TESTDB, port);
    }

    public static void stop(String dbName, int port) {
        if (0 == --startCount) {
            LOGGER.debug("############# ({}) shutting down HsqlServer", (Object)startCount);
            HsqlServer.shutdown(dbName, port);
        } else {
            LOGGER.debug("############# ({}) not shutting down HsqlServer", (Object)startCount);
        }
    }

    private static void shutdown(String dbName, int port) {
        String jdbcUrl = "jdbc:hsqldb:hsql://localhost:" + port + "/" + dbName;
        try (Connection connection = DriverManager.getConnection(jdbcUrl, "sa", "");
             Statement createStatement = connection.createStatement();){
            createStatement.execute("SHUTDOWN");
        }
        catch (SQLException e) {
            LOGGER.info("failed shutting down, must be first start: {}", (Object)e.getMessage());
        }
    }
}

