/*
 * Decompiled with CFR 0.152.
 */
package org.appng.testsupport.persistence;

import org.appng.testsupport.persistence.ConnectionInfo;
import org.dbunit.ext.hsqldb.HsqldbConnection;
import org.dbunit.ext.mysql.MySqlConnection;

public class ConnectionHelper {
    private static final String HSQL_PORT = "hsqlPort";
    public static final String HIBERNATE_CONNECTION_URL = "hibernate.connection.url";
    private static final int MYSQL_DEFAULT_PORT = 3306;
    private static final DBType type = DBType.HSQL;

    public static ConnectionInfo getMySqlConnectionInfo() {
        return ConnectionHelper.getMySqlConnectionInfo("aitwf_testdb", "mysql-testdb", "root", "mysql");
    }

    public static ConnectionInfo getHSqlConnectionInfo(int port) {
        return ConnectionHelper.getHSqlConnectionInfo("hsql-testdb", port, "hsql-testdb", "sa", "");
    }

    public static ConnectionInfo getHSqlConnectionInfo() {
        return ConnectionHelper.getHSqlConnectionInfo(ConnectionHelper.getHsqlPort());
    }

    public static ConnectionInfo getMySqlConnectionInfo(String database, String persistenceUnit, String user, String password) {
        ConnectionInfo connectionInfo = new ConnectionInfo("jdbc:mysql://localhost:3306/" + database, 3306, user, password, "com.mysql.jdbc.Driver", persistenceUnit, MySqlConnection.class);
        return connectionInfo;
    }

    public static ConnectionInfo getHSqlConnectionInfo(String database, int port, String persistenceUnit, String user, String password) {
        ConnectionInfo connectionInfo = new ConnectionInfo("jdbc:hsqldb:hsql://localhost:" + port + "/" + database, port, user, password, "org.hsqldb.jdbc.JDBCDriver", persistenceUnit, HsqldbConnection.class);
        return connectionInfo;
    }

    public static int getHsqlPort() {
        int hsqlPort = 9001;
        String portProperty = System.getProperty(HSQL_PORT);
        if (null == portProperty) {
            portProperty = System.getenv(HSQL_PORT);
        }
        if (null != portProperty) {
            try {
                hsqlPort = Integer.parseInt(portProperty);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        System.setProperty(HSQL_PORT, String.valueOf(hsqlPort));
        return hsqlPort;
    }

    public static ConnectionInfo getHSqlConnectionInfo(String database, String persistenceUnit, String user, String password) {
        return ConnectionHelper.getHSqlConnectionInfo(database, ConnectionHelper.getHsqlPort(), persistenceUnit, user, password);
    }

    public static ConnectionInfo getConnectionInfo() {
        return ConnectionHelper.getConnectionInfo(type);
    }

    public static ConnectionInfo getConnectionInfo(DBType type) {
        switch (type) {
            case HSQL: {
                return ConnectionHelper.getHSqlConnectionInfo(9001);
            }
            case MYSQL: {
                return ConnectionHelper.getMySqlConnectionInfo();
            }
        }
        throw new IllegalArgumentException("no such type :" + (Object)((Object)type));
    }

    public static enum DBType {
        MYSQL,
        HSQL,
        DERBY;

    }
}

