/*
 * Decompiled with CFR 0.152.
 */
package org.appng.testsupport.persistence;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import org.hsqldb.Server;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.InitializingBean;

public class HsqlServerFactoryBean
implements FactoryBean<Server>,
InitializingBean,
DisposableBean {
    private static final Logger LOG = LoggerFactory.getLogger(HsqlServerFactoryBean.class);
    private String databaseName = "hsql-testdb";
    private int port = 9001;
    private String databasePath;
    private Server server;

    public Server getObject() throws Exception {
        return this.server;
    }

    public Class<?> getObjectType() {
        return Server.class;
    }

    public boolean isSingleton() {
        return true;
    }

    public void destroy() {
        LOG.debug("shutting down HSQL Server {} at {} on port {}", new Object[]{this.server.getProductVersion(), this.server.getDatabasePath(0, false), this.server.getPort()});
        String jdbcUrl = String.format("jdbc:hsqldb:hsql://localhost:%s/%s", this.server.getPort(), this.databaseName);
        try (Connection connection = DriverManager.getConnection(jdbcUrl, "sa", "");){
            connection.createStatement().execute("SHUTDOWN");
        }
        catch (SQLException e) {
            LOG.warn("error while shutting down server", (Throwable)e);
        }
        this.server.shutdown();
    }

    public void init() {
        LOG.debug("starting HSQL Server {} at {} on port {}", new Object[]{this.server.getProductVersion(), this.server.getDatabasePath(0, false), this.server.getPort()});
        this.server.start();
    }

    public void afterPropertiesSet() throws Exception {
        this.server = new Server();
        this.server.setLogWriter(null);
        this.server.setSilent(true);
        this.server.setNoSystemExit(true);
        this.server.setDatabaseName(0, this.getDatabaseName());
        this.server.setDatabasePath(0, this.getDatabasePath());
        this.server.setPort(this.getPort());
        this.server.setTrace(false);
    }

    public String getDatabaseName() {
        return this.databaseName;
    }

    public void setDatabaseName(String databaseName) {
        this.databaseName = databaseName;
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public String getDatabasePath() {
        return null == this.databasePath ? "file:target/hsql/" + this.databaseName : this.databasePath;
    }

    public void setDatabasePath(String databasePath) {
        if (null != databasePath) {
            this.databasePath = databasePath;
        }
    }

    public String toString() {
        return "database " + this.getDatabaseName() + " at port " + this.port + " (" + this.getDatabasePath() + ")";
    }
}

