/*
 * Decompiled with CFR 0.152.
 */
package org.appng.testsupport.persistence;

import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Constructor;
import java.net.URL;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import java.util.Map;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import javax.persistence.EntityTransaction;
import javax.persistence.Persistence;
import org.appng.testsupport.persistence.ConnectionHelper;
import org.appng.testsupport.persistence.ConnectionInfo;
import org.appng.testsupport.persistence.TestDataProvider;
import org.dbunit.DatabaseUnitException;
import org.dbunit.database.IDatabaseConnection;
import org.dbunit.database.QueryDataSet;
import org.dbunit.dataset.DataSetException;
import org.dbunit.dataset.IDataSet;
import org.dbunit.dataset.excel.XlsDataSet;
import org.dbunit.dataset.xml.FlatDtdDataSet;
import org.dbunit.dataset.xml.FlatXmlDataSet;
import org.dbunit.dataset.xml.FlatXmlDataSetBuilder;
import org.dbunit.dataset.xml.FlatXmlWriter;
import org.dbunit.operation.DatabaseOperation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DatabaseUtil {
    private final Logger logger = LoggerFactory.getLogger(DatabaseUtil.class);
    private static final ClassLoader CLASS_LOADER = DatabaseUtil.class.getClassLoader();
    private final FlatXmlDataSetBuilder XML_BUILDER = new FlatXmlDataSetBuilder();
    private IDatabaseConnection connection;
    private Connection jdbcConnection;
    private final String SCHEMA;
    private static volatile boolean imported = false;
    private ConnectionInfo connectionInfo;

    private synchronized void openConnection() throws Exception {
        try {
            this.jdbcConnection = this.getJDBConnection();
            this.logger.info("JDBC-Connection created: " + this.jdbcConnection);
            this.connection = this.getConnection();
            this.logger.debug("connection created: " + this.connection.getClass().getName());
        }
        catch (Exception e) {
            this.logger.error("an error occured", (Throwable)e);
            throw e;
        }
    }

    private Connection getJDBConnection() throws ClassNotFoundException, SQLException {
        String connectionUrl = this.connectionInfo.getJdbcUrl();
        String driver = this.connectionInfo.getDriverClass();
        String userName = this.connectionInfo.getUser();
        String password = this.connectionInfo.getPassword();
        this.logger.info("using datasource " + connectionUrl + " " + userName + "/****");
        Class.forName(driver);
        Connection connection = DriverManager.getConnection(connectionUrl, userName, password);
        return connection;
    }

    public DatabaseUtil(ConnectionInfo info) {
        this.SCHEMA = null;
        this.connectionInfo = info;
    }

    public void importData(String name) throws Exception {
        this.importData(name, false);
    }

    public void importData(String name, boolean force) throws Exception {
        this.importData(name, force, true);
    }

    public void importData(Class<? extends TestDataProvider> testDataProviderClass) throws Exception {
        this.logger.info("found TestDataProvider " + testDataProviderClass);
        TestDataProvider testDataProvider = testDataProviderClass.newInstance();
        this.clearDBJPA(true, testDataProvider);
    }

    public void importData(TestDataProvider testDataProvider) throws Exception {
        this.clearDBJPA(true, testDataProvider);
    }

    public void importData(String name, boolean force, boolean clearDb) throws Exception {
        if (!imported || force) {
            this.XML_BUILDER.setColumnSensing(true);
            long start = System.currentTimeMillis();
            long end = -1L;
            try {
                this.clearDBJPA(clearDb, null);
                this.openConnection();
                this.importFile("dbunit/" + name + ".xml");
                this.shutDown();
                imported = true;
            }
            catch (Exception e) {
                throw e;
            }
            finally {
                end = System.currentTimeMillis();
            }
            this.logger.info("finished DBExport in " + (end - start) + "ms");
        }
    }

    public void exportData(String dataName) {
        this.exportData(dataName, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void exportData(String dataName, boolean clearDb, Class<? extends TestDataProvider> testDataProviderClass) {
        this.XML_BUILDER.setColumnSensing(true);
        long start = System.currentTimeMillis();
        try {
            this.openConnection();
            this.logger.info("found TestDataProvider " + testDataProviderClass);
            TestDataProvider testDataProvider = testDataProviderClass.newInstance();
            this.clearDBJPA(clearDb, testDataProvider);
            this.export(dataName);
            this.shutDown();
        }
        catch (Exception e) {
            this.logger.error("an error occured", (Throwable)e);
        }
        finally {
            long end = System.currentTimeMillis();
            this.logger.info("finished DBExport in " + (end - start) + "ms");
        }
    }

    public void exportData(String dataName, Class<? extends TestDataProvider> testDataProvider) {
        this.exportData(dataName, true, testDataProvider);
    }

    public void shutDown() throws SQLException {
        try {
            this.connection.close();
            this.jdbcConnection.close();
            this.logger.debug("shutting down connection " + this.connection.getClass().getSimpleName());
        }
        catch (SQLException e) {
            this.logger.error("error whole closing the connection", (Throwable)e);
            throw e;
        }
    }

    public void importData(Map<String, String> properties, Class<? extends TestDataProvider> testDataProvider) throws Exception {
        HashMap<String, String> copy = new HashMap<String, String>(properties);
        copy.put("hibernate.hbm2ddl.auto", "create");
        EntityManagerFactory emf = null;
        EntityManager em = null;
        EntityTransaction tx = null;
        try {
            this.logger.info("clearing database...");
            HashMap<String, String> props = new HashMap<String, String>();
            props.put("hibernate.hbm2ddl.auto", "create");
            emf = Persistence.createEntityManagerFactory((String)this.connectionInfo.getPersistenceUnit(), copy);
            em = emf.createEntityManager();
            tx = em.getTransaction();
            tx.begin();
            if (testDataProvider != null) {
                this.logger.info("writing testdata");
                testDataProvider.newInstance().writeTestData(em);
                this.logger.info("done importing testdata");
            }
            this.logger.info("...done clearing");
        }
        catch (Exception e) {
            this.logger.error(e.getMessage(), (Throwable)e);
            throw e;
        }
        finally {
            if (tx != null) {
                if (tx.getRollbackOnly()) {
                    tx.rollback();
                } else {
                    tx.commit();
                }
            }
            if (em != null) {
                em.close();
            }
            if (emf != null) {
                emf.close();
            }
        }
    }

    public void clearDBJPA(boolean createSchema, TestDataProvider testDataProvider) throws Exception {
        this.clearDBJPA(createSchema, false, testDataProvider);
    }

    public void clearDBJPA(boolean createSchema, boolean showSql, TestDataProvider testDataProvider) throws Exception {
        EntityManagerFactory emf = null;
        EntityManager em = null;
        try {
            this.logger.info("clearing database...");
            HashMap<String, String> props = new HashMap<String, String>();
            if (createSchema) {
                props.put("hibernate.hbm2ddl.auto", "create");
                if (showSql) {
                    props.put("hibernate.show_sql", "true");
                }
                this.logger.info("setting hibernate.hbm2ddl.auto to 'create'");
            }
            emf = Persistence.createEntityManagerFactory((String)this.connectionInfo.getPersistenceUnit(), props);
            em = emf.createEntityManager();
            em.getTransaction().begin();
            this.logger.info("EntityManager created");
            this.logger.info("EntityTransaction created");
            this.logger.info("EntityTransaction started");
            if (testDataProvider != null) {
                this.logger.info("writing testdata");
                testDataProvider.writeTestData(em);
                this.logger.info("done importing testdata");
            }
            this.logger.info("...done clearing");
        }
        catch (Exception e) {
            this.logger.error(e.getMessage(), (Throwable)e);
            throw e;
        }
        em.getTransaction().commit();
        em.close();
        emf.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearDB() {
        try {
            this.logger.info("clearing database...");
            for (int i = this.connectionInfo.getTableNames().size(); i > 0; --i) {
                String table = this.connectionInfo.getTableNames().get(i - 1);
                Statement statement = this.jdbcConnection.createStatement();
                String stmt = "delete from " + (null != this.SCHEMA ? this.SCHEMA + "." : "") + table;
                int rows = statement.executeUpdate(stmt);
                this.logger.debug(".....clearing " + table + " (" + rows + " rows deleted)");
                statement.close();
            }
            this.logger.info("...done clearing");
        }
        catch (Throwable e) {
            this.logger.error(e.getMessage(), e);
        }
    }

    private void importFile(String path) throws Exception {
        long start = System.currentTimeMillis();
        try {
            this.execute(path, DatabaseOperation.INSERT);
            long end = System.currentTimeMillis();
            this.logger.info("imported " + path + " in " + (end - start) + "ms");
        }
        catch (Exception e) {
            this.logger.error("error while importing file", (Throwable)e);
            throw e;
        }
    }

    public void delete(String path) {
        try {
            this.execute(path, DatabaseOperation.DELETE);
        }
        catch (Exception e) {
            this.logger.error("error while importing file", (Throwable)e);
        }
    }

    private void execute(String path, DatabaseOperation operation) throws Exception {
        ClassLoader classLoader = CLASS_LOADER;
        XlsDataSet dataSet = null;
        if (path.endsWith(".xls")) {
            InputStream file = classLoader.getResourceAsStream(path);
            dataSet = new XlsDataSet(file);
        } else if (path.endsWith(".xml")) {
            URL file = classLoader.getResource(path);
            dataSet = this.XML_BUILDER.build(file);
        } else {
            throw new DataSetException("unknow data type");
        }
        operation.execute(this.connection, (IDataSet)dataSet);
    }

    public void export(String name) throws Exception {
        if (null == this.connection) {
            this.openConnection();
        }
        QueryDataSet dataSet = new QueryDataSet(this.connection);
        for (String table : this.connectionInfo.getTableNames()) {
            this.logger.info("adding table '" + table + "' to testdata");
            dataSet.addTable(table);
        }
        this.exportDTD(dataSet, name);
        this.exportXml((IDataSet)dataSet, name);
    }

    private void exportDTD(QueryDataSet dataSet, String name) throws Exception {
        File outFolder = new File("src/test/resources/dbunit/");
        if (!outFolder.exists()) {
            outFolder.mkdirs();
        }
        File out = new File(outFolder, name + ".dtd");
        FlatDtdDataSet.write((IDataSet)dataSet, (OutputStream)new FileOutputStream(out));
        this.logger.info("created " + out.getAbsolutePath());
    }

    private void exportXml(IDataSet dataSet, String name) throws Exception {
        File out = new File("src/test/resources/dbunit/" + name + ".xml");
        FileOutputStream outStream = new FileOutputStream(out);
        FlatXmlWriter datasetWriter = new FlatXmlWriter((OutputStream)outStream);
        datasetWriter.setDocType(name + ".dtd");
        datasetWriter.write(dataSet);
        this.logger.info("created " + out.getAbsolutePath());
    }

    private void exportXls(IDataSet dataSet, String file) throws Exception {
        XlsDataSet.write((IDataSet)dataSet, (OutputStream)new FileOutputStream("src/test/resources/" + file));
    }

    public void xlsToXml(String file) throws Exception {
        XlsDataSet dataSet = new XlsDataSet(CLASS_LOADER.getResourceAsStream(file));
        this.exportXml((IDataSet)dataSet, file.replace("xls", "xml"));
    }

    public void xmlToXls(String file) throws Exception {
        URL resource = CLASS_LOADER.getResource(file);
        FlatXmlDataSet dataSet = this.XML_BUILDER.build(resource);
        this.exportXls((IDataSet)dataSet, file.replace("xml", "xls"));
    }

    private IDatabaseConnection getConnection() throws Exception, DatabaseUnitException {
        Constructor<? extends IDatabaseConnection> constructor = this.connectionInfo.getConnection().getConstructor(Connection.class, String.class);
        IDatabaseConnection connection = constructor.newInstance(this.jdbcConnection, null);
        return connection;
    }

    public ConnectionInfo getConnectionInfo() {
        return this.connectionInfo;
    }

    public static Map<String, String> importTestData(Class<? extends TestDataProvider> class1) throws Exception {
        ConnectionInfo connectionInfo = ConnectionHelper.getHSqlConnectionInfo();
        return DatabaseUtil.importTestData(class1, connectionInfo);
    }

    public static Map<String, String> importTestData(Class<? extends TestDataProvider> class1, ConnectionInfo connectionInfo) throws Exception {
        String jdbcUrl = connectionInfo.getJdbcUrl();
        HashMap<String, String> properties = new HashMap<String, String>();
        properties.put("hibernate.connection.url", jdbcUrl);
        DatabaseUtil databaseUtil = new DatabaseUtil(connectionInfo);
        databaseUtil.importData(properties, class1);
        return properties;
    }
}

