/*
 * Decompiled with CFR 0.152.
 */
package org.appng.testsupport.persistence;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.sql.Driver;
import java.util.List;
import javax.sql.DataSource;
import org.dbunit.database.IDatabaseConnection;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.datasource.SimpleDriverDataSource;
import org.springframework.jdbc.datasource.init.ScriptUtils;

public class ConnectionInfo {
    private String jdbcUrl;
    private int port;
    private String user;
    private String password;
    private String driverClass;
    private String persistenceUnit;
    private Class<? extends IDatabaseConnection> connection;
    private List<String> tableNames;
    private Driver driver;

    public ConnectionInfo(String jdbcUrl, int port, String user, String password, String driverClass, String persistenceUnit, Class<? extends IDatabaseConnection> connection) {
        this.jdbcUrl = jdbcUrl;
        this.port = port;
        this.user = user;
        this.password = password;
        this.driverClass = driverClass;
        this.persistenceUnit = persistenceUnit;
        this.connection = connection;
        try {
            this.driver = (Driver)Class.forName(driverClass).newInstance();
        }
        catch (Exception e) {
            throw new IllegalArgumentException("can not instantiate driver class", e);
        }
    }

    public String getJdbcUrl() {
        return this.jdbcUrl;
    }

    public void setJdbcUrl(String jdbcUrl) {
        this.jdbcUrl = jdbcUrl;
    }

    public String getUser() {
        return this.user;
    }

    public void setUser(String user) {
        this.user = user;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getDriverClass() {
        return this.driverClass;
    }

    public void setDriverClass(String driverClass) {
        this.driverClass = driverClass;
    }

    public Class<? extends IDatabaseConnection> getConnection() {
        return this.connection;
    }

    public void setConnection(Class<? extends IDatabaseConnection> connection) {
        this.connection = connection;
    }

    public String getPersistenceUnit() {
        return this.persistenceUnit;
    }

    public void setPersistenceUnit(String persistenceUnit) {
        this.persistenceUnit = persistenceUnit;
    }

    public List<String> getTableNames() {
        return this.tableNames;
    }

    public void setTableNames(List<String> tableNames) {
        this.tableNames = tableNames;
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public void executeSqlFromResource(String resourceName) throws IOException {
        InputStream resource = Thread.currentThread().getContextClassLoader().getResourceAsStream(resourceName);
        String viewScript = ScriptUtils.readScript((LineNumberReader)new LineNumberReader(new InputStreamReader(resource)), (String)"--", (String)";");
        this.executeSql(viewScript);
    }

    public void executeSql(String sql) {
        SimpleDriverDataSource dataSource = new SimpleDriverDataSource(this.driver, this.getJdbcUrl(), this.getUser(), this.getPassword());
        JdbcTemplate jdbcTemplate = new JdbcTemplate((DataSource)dataSource);
        jdbcTemplate.execute(sql);
    }
}

