/*
 * Decompiled with CFR 0.152.
 */
package org.appng.testsupport.persistence;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.sql.Statement;
import org.hsqldb.Server;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HsqlServer {
    public static final int DEFAULT_PORT = 9001;
    private static final String HSQL_TESTDB = "hsql-testdb";
    private static final Logger LOG = LoggerFactory.getLogger(HsqlServer.class);
    private static volatile int startCount = 0;

    public static void main(String[] args) {
        HsqlServer.start(9001);
        HsqlServer.stop(9001);
        HsqlServer.start(9001);
        HsqlServer.stop(9001);
    }

    public static void start() {
        HsqlServer.start(HSQL_TESTDB, 9001);
    }

    public static void start(String dbName) {
        HsqlServer.start(dbName, 9001);
    }

    public static void stop() {
        HsqlServer.stop(HSQL_TESTDB, 9001);
    }

    public static void stop(String dbName) {
        HsqlServer.stop(dbName, 9001);
    }

    public static void start(int port) {
        HsqlServer.start(HSQL_TESTDB, port);
    }

    public static void start(String dbName, int port) {
        HsqlServer.start(dbName, dbName, port);
    }

    public static void start(String dbName, String folder, int port) {
        if (startCount == 0) {
            LOG.debug("############# (" + startCount + ") starting HsqlServer");
            String[] params = new String[]{"-database.0", "file:target/hsql/" + folder + "/", "-dbname.0", dbName, "-no_system_exit", "true", "-port", String.valueOf(port)};
            Server.main((String[])params);
        } else {
            LOG.debug("############# (" + startCount + ") HsqlServer already started");
        }
        ++startCount;
    }

    public static void stop(int port) {
        HsqlServer.stop(HSQL_TESTDB, port);
    }

    public static void stop(String dbName, int port) {
        if (0 == --startCount) {
            LOG.debug("############# (" + startCount + ") shutting down HsqlServer");
            HsqlServer.shutdown(dbName, port);
        } else {
            LOG.debug("############# (" + startCount + ") not shutting down HsqlServer");
        }
    }

    private static void shutdown(String dbName, int port) {
        try {
            String jdbcUrl = "jdbc:hsqldb:hsql://localhost:" + port + "/" + dbName;
            Connection connection = DriverManager.getConnection(jdbcUrl, "sa", "");
            Statement createStatement = connection.createStatement();
            createStatement.execute("SHUTDOWN");
        }
        catch (SQLException e) {
            LOG.info("failed shutting down, must be first start:" + e.getMessage());
        }
    }
}

