/*
 * Decompiled with CFR 0.152.
 */
package org.appng.testsupport;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeoutException;
import javax.servlet.ServletContext;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import javax.xml.bind.JAXBException;
import org.apache.commons.io.FilenameUtils;
import org.appng.api.ApplicationConfigProvider;
import org.appng.api.BusinessException;
import org.appng.api.Environment;
import org.appng.api.FieldProcessor;
import org.appng.api.FileUpload;
import org.appng.api.InvalidConfigurationException;
import org.appng.api.ParameterSupport;
import org.appng.api.Path;
import org.appng.api.PermissionProcessor;
import org.appng.api.ProcessingException;
import org.appng.api.Scope;
import org.appng.api.VHostMode;
import org.appng.api.model.Application;
import org.appng.api.model.ApplicationSubject;
import org.appng.api.model.FeatureProvider;
import org.appng.api.model.Group;
import org.appng.api.model.Resource;
import org.appng.api.model.Resources;
import org.appng.api.model.SimpleProperty;
import org.appng.api.model.Site;
import org.appng.api.model.Subject;
import org.appng.api.search.Consumer;
import org.appng.api.search.DocumentEvent;
import org.appng.api.search.DocumentProducer;
import org.appng.api.support.ApplicationConfigProviderImpl;
import org.appng.api.support.ApplicationRequest;
import org.appng.api.support.ApplicationResourceHolder;
import org.appng.api.support.CallableAction;
import org.appng.api.support.CallableDataSource;
import org.appng.api.support.DollarParameterSupport;
import org.appng.api.support.DummyPermissionProcessor;
import org.appng.api.support.PropertyHolder;
import org.appng.api.support.environment.DefaultEnvironment;
import org.appng.forms.FormUpload;
import org.appng.forms.Request;
import org.appng.forms.impl.FormUploadBean;
import org.appng.forms.impl.RequestBean;
import org.appng.testsupport.persistence.ConnectionHelper;
import org.appng.testsupport.validation.WritingXmlValidator;
import org.appng.tools.image.ImageProcessor;
import org.appng.xml.BaseObject;
import org.appng.xml.MarshallService;
import org.appng.xml.application.ApplicationInfo;
import org.appng.xml.application.Permission;
import org.appng.xml.application.PermissionRef;
import org.appng.xml.application.Property;
import org.appng.xml.application.Role;
import org.appng.xml.platform.ActionRef;
import org.appng.xml.platform.DatasourceRef;
import org.appng.xml.platform.FieldDef;
import org.appng.xml.platform.Param;
import org.appng.xml.platform.Params;
import org.custommonkey.xmlunit.DifferenceListener;
import org.junit.Before;
import org.junit.runner.RunWith;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;
import org.springframework.beans.BeanWrapperImpl;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.config.BeanFactoryPostProcessor;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.context.ApplicationContextInitializer;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.MessageSource;
import org.springframework.context.support.GenericApplicationContext;
import org.springframework.context.support.PropertySourcesPlaceholderConfigurer;
import org.springframework.context.support.ResourceBundleMessageSource;
import org.springframework.core.convert.ConversionService;
import org.springframework.mock.web.MockHttpServletRequest;
import org.springframework.mock.web.MockHttpServletResponse;
import org.springframework.mock.web.MockHttpSession;
import org.springframework.test.annotation.DirtiesContext;
import org.springframework.test.context.ContextConfiguration;
import org.springframework.test.context.junit4.SpringJUnit4ClassRunner;

@ContextConfiguration(locations={"file:application-home/beans.xml", "classpath:org/appng/testsupport/application-testcontext.xml"})
@RunWith(value=SpringJUnit4ClassRunner.class)
@DirtiesContext
public class TestBase
implements ApplicationContextInitializer<GenericApplicationContext> {
    public static final String TESTCONTEXT = "classpath:org/appng/testsupport/application-testcontext.xml";
    public static final String TESTCONTEXT_CORE = "classpath:org/appng/testsupport/application-testcontext-core.xml";
    public static final String TESTCONTEXT_JPA = "classpath:org/appng/testsupport/application-testcontext-jpa.xml";
    public static final String BEANS_PATH = "file:application-home/beans.xml";
    protected static final String APPLICATION_HOME = "application-home";
    protected static final String FORM_ACTION = "form_action";
    private static final String SITE_MANAGER_PATH = "/manager";
    private static final String SITE_SERVICE_PATH = "/service";
    @Autowired
    protected ServletContext servletContext;
    protected HttpSession session;
    @Autowired
    protected MockHttpServletRequest servletRequest;
    protected MockHttpServletResponse servletResponse = new MockHttpServletResponse();
    @Autowired
    protected ConfigurableApplicationContext context;
    @Autowired
    protected MessageSource messageSource;
    @Autowired
    protected ConversionService conversionService;
    @Autowired
    protected MarshallService marshallService;
    @Autowired
    @Qualifier(value="applicationMarshallService")
    private MarshallService applicationMarshallService;
    protected Environment environment;
    protected ApplicationRequest request;
    protected Application application;
    @Mock
    protected Site site;
    @Mock
    protected Subject subject;
    @Mock
    protected Path path;
    private String applicationName;
    private String applicationLocation;
    private String entityPackage;
    private String repositoryBase;
    private boolean useFullClassname = false;
    private Map<String, String> parameters = new HashMap<String, String>();

    public TestBase() {
        this("application", APPLICATION_HOME);
    }

    public TestBase(String name) {
        this(name, APPLICATION_HOME);
    }

    protected void subjectWithRole(String roleName) {
        Group group = (Group)Mockito.mock(Group.class);
        Mockito.when((Object)group.getRoles()).thenReturn(new HashSet());
        for (org.appng.api.model.Role role : this.application.getRoles()) {
            if (!role.getName().equals(roleName)) continue;
            group.getRoles().add(role);
        }
        ArrayList<Group> groups = new ArrayList<Group>();
        groups.add(group);
        Mockito.when((Object)this.subject.getGroups()).thenReturn(groups);
    }

    public TestBase(String applicationName, String applicationLocation) {
        Locale.setDefault(Locale.ENGLISH);
        this.applicationName = applicationName;
        this.applicationLocation = applicationLocation;
    }

    public void initialize(GenericApplicationContext applicationContext) {
        Properties properties = this.getProperties();
        PropertySourcesPlaceholderConfigurer placeholderConfigurer = new PropertySourcesPlaceholderConfigurer();
        placeholderConfigurer.setProperties(properties);
        applicationContext.addBeanFactoryPostProcessor((BeanFactoryPostProcessor)placeholderConfigurer);
        File dictFolder = new File(this.applicationLocation + "/dictionary").getAbsoluteFile();
        final ArrayList<String> baseNames = new ArrayList<String>();
        if (dictFolder.exists() && dictFolder.list() != null) {
            for (String file : dictFolder.list()) {
                String name;
                if (!FilenameUtils.getExtension((String)file).equalsIgnoreCase("properties") || baseNames.contains(name = FilenameUtils.getBaseName((String)file).replaceAll("_(.)*", ""))) continue;
                baseNames.add(name);
            }
            try {
                URL dictUrl = dictFolder.toURI().toURL();
                URLClassLoader classLoader = new URLClassLoader(new URL[]{dictUrl}, this.getClass().getClassLoader());
                applicationContext.setClassLoader((ClassLoader)classLoader);
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
        }
        applicationContext.addBeanFactoryPostProcessor(new BeanFactoryPostProcessor(){

            public void postProcessBeanFactory(ConfigurableListableBeanFactory beanFactory) throws BeansException {
                baseNames.add("messages-core");
                ResourceBundleMessageSource bean = (ResourceBundleMessageSource)beanFactory.getBean(ResourceBundleMessageSource.class);
                bean.setBasenames(baseNames.toArray(new String[baseNames.size()]));
            }
        });
    }

    protected Properties getProperties() {
        Properties properties = new Properties();
        properties.put("entityPackage", this.entityPackage);
        properties.put("hsqlPort", (Object)ConnectionHelper.getHsqlPort());
        properties.put("repositoryBase", this.repositoryBase);
        return properties;
    }

    protected void addParameter(String name, String value) {
        this.parameters.put(name, value);
    }

    protected FormUpload getFormUpload(String resourceName) throws URISyntaxException {
        URL resource = this.getClass().getClassLoader().getResource(resourceName);
        File file = new File(resource.toURI());
        String extension = FilenameUtils.getExtension((String)resourceName);
        long maxSize = 10L * FileUpload.Unit.MB.getFactor();
        return new FormUploadBean(file, file.getName(), extension, Arrays.asList(extension), maxSize);
    }

    @Before
    public void setup() throws Exception {
        MockitoAnnotations.initMocks((Object)this);
        this.initEnvironment();
        this.application = new SimpleApplication(this.applicationName, this.context, this.getApplicationSubjects());
        this.initRequest();
        ((SimpleApplication)this.application).init(this.getProperties(), this.request.getApplicationConfig().getApplicationInfo());
    }

    protected List<ApplicationSubject> getApplicationSubjects() {
        return new ArrayList<ApplicationSubject>();
    }

    protected void initRequest() throws InvalidConfigurationException, JAXBException {
        File targetFolder = new File("target/temp");
        File applicationFolder = new File(this.applicationLocation);
        ApplicationResourceHolder applicationResources = new ApplicationResourceHolder(this.application, this.applicationMarshallService, applicationFolder, targetFolder);
        ApplicationConfigProviderImpl applicationConfigProvider = new ApplicationConfigProviderImpl(this.marshallService, this.applicationName, (Resources)applicationResources, false);
        this.request = (ApplicationRequest)this.context.getBean(org.appng.api.Request.class);
        this.request.setPermissionProcessor((PermissionProcessor)new DummyPermissionProcessor(this.subject, this.site, this.application));
        this.request.setApplicationConfig((ApplicationConfigProvider)applicationConfigProvider);
    }

    protected void initParameters() {
        this.initParameters(false);
    }

    protected void initParameters(boolean isPost) {
        this.servletRequest.setParameters(this.parameters);
        this.init(isPost);
    }

    protected void init(boolean isPost) {
        if (isPost) {
            this.servletRequest.setMethod("POST");
        }
        RequestBean requestBean = new RequestBean();
        requestBean.process((HttpServletRequest)this.servletRequest);
        this.request.setWrappedRequest((Request)requestBean);
    }

    protected void initEnvironment() {
        ConcurrentHashMap<String, Object> platformEnv = new ConcurrentHashMap<String, Object>();
        List<org.appng.api.model.Property> platformProperties = this.getPlatformProperties("platform.");
        platformEnv.put("platformConfig", new PropertyHolder("platform.", platformProperties));
        Mockito.when((Object)this.site.getName()).thenReturn((Object)"localhost");
        Mockito.when((Object)this.site.getDomain()).thenReturn((Object)"localhost");
        Mockito.when((Object)this.site.getHost()).thenReturn((Object)"localhost");
        Mockito.when((Object)this.site.getSiteClassLoader()).thenReturn((Object)new URLClassLoader(new URL[0]));
        HashMap<String, Site> sites = new HashMap<String, Site>();
        sites.put("localhost", this.site);
        platformEnv.put("sites", sites);
        List<org.appng.api.model.Property> siteProperties = this.getSiteProperties("platform.site.localhost.");
        Mockito.when((Object)this.site.getProperties()).thenReturn((Object)new PropertyHolder("platform.site.localhost.", siteProperties));
        this.session = new MockHttpSession(this.servletContext);
        this.servletContext.setAttribute(Scope.PLATFORM.name(), platformEnv);
        this.environment = (Environment)this.context.getBean("environment", Environment.class);
        if (!((DefaultEnvironment)this.environment).isInitialized()) {
            this.environment.init(this.servletContext, this.session, (ServletRequest)this.servletRequest, (ServletResponse)this.servletResponse, this.site.getHost());
        }
        this.environment.setAttribute(Scope.REQUEST, "pathInfo", (Object)this.path);
        Mockito.when((Object)this.path.getServicePath()).thenReturn((Object)SITE_SERVICE_PATH);
        Mockito.when((Object)this.path.getGuiPath()).thenReturn((Object)SITE_MANAGER_PATH);
    }

    protected List<org.appng.api.model.Property> getSiteProperties(String prefix) {
        ArrayList<org.appng.api.model.Property> siteProperties = new ArrayList<org.appng.api.model.Property>();
        siteProperties.add((org.appng.api.model.Property)new SimpleProperty(prefix + "service-path", SITE_SERVICE_PATH));
        siteProperties.add((org.appng.api.model.Property)new SimpleProperty(prefix + "manager-path", SITE_MANAGER_PATH));
        siteProperties.add((org.appng.api.model.Property)new SimpleProperty(prefix + "defaultPageSize", "25"));
        return siteProperties;
    }

    protected List<org.appng.api.model.Property> getPlatformProperties(String prefix) {
        ArrayList<org.appng.api.model.Property> platformProperties = new ArrayList<org.appng.api.model.Property>();
        platformProperties.add((org.appng.api.model.Property)new SimpleProperty(prefix + "vHostMode", VHostMode.NAME_BASED.name()));
        platformProperties.add((org.appng.api.model.Property)new SimpleProperty(prefix + "locale", "en"));
        platformProperties.add((org.appng.api.model.Property)new SimpleProperty(prefix + "timeZone", "Europe/Berlin"));
        platformProperties.add((org.appng.api.model.Property)new SimpleProperty(prefix + "platformRootPath", "target/ROOT"));
        platformProperties.add((org.appng.api.model.Property)new SimpleProperty(prefix + "cacheFolder", "cache"));
        platformProperties.add((org.appng.api.model.Property)new SimpleProperty(prefix + "cacheApplicationFolder", "application"));
        platformProperties.add((org.appng.api.model.Property)new SimpleProperty(prefix + "cachePlatformFolder", "platform"));
        platformProperties.add((org.appng.api.model.Property)new SimpleProperty(prefix + "uploadDir", "/target/uploads"));
        platformProperties.add((org.appng.api.model.Property)new SimpleProperty(prefix + "maxUploadSize", "10485760"));
        platformProperties.add((org.appng.api.model.Property)new SimpleProperty(prefix + "xssProtect", "false"));
        return platformProperties;
    }

    public void validate(BaseObject object) throws IOException {
        String controlFile = this.getControlFileName(null);
        WritingXmlValidator.validateXml(object, controlFile);
    }

    public void validate(BaseObject object, DifferenceListener differenceListener) throws IOException {
        String controlFile = this.getControlFileName(null);
        WritingXmlValidator.validateXml(object, controlFile, differenceListener);
    }

    public void validate(BaseObject object, String suffix, DifferenceListener differenceListener) throws IOException {
        String controlFile = this.getControlFileName(suffix);
        WritingXmlValidator.validateXml(object, controlFile, differenceListener);
    }

    public void validate(BaseObject object, String suffix) throws IOException {
        String controlFile = this.getControlFileName(suffix);
        WritingXmlValidator.validateXml(object, controlFile);
    }

    private String getControlFileName(String suffix) {
        StackTraceElement[] stackTrace = Thread.currentThread().getStackTrace();
        StackTraceElement stackTraceElement = stackTrace[3];
        String className = stackTraceElement.getClassName();
        if (!this.useFullClassname) {
            className = className.substring(className.lastIndexOf(46) + 1);
        }
        String controlFile = "xml" + File.separator + className + "-" + stackTraceElement.getMethodName() + (suffix == null ? "" : suffix) + ".xml";
        return controlFile;
    }

    protected String getEntityPackage() {
        return this.entityPackage;
    }

    protected void setEntityPackage(String entityPackage) {
        this.entityPackage = entityPackage;
    }

    protected String getRepositoryBase() {
        return this.repositoryBase;
    }

    protected void setRepositoryBase(String repositoryBase) {
        this.repositoryBase = repositoryBase;
    }

    protected boolean isUseFullClassname() {
        return this.useFullClassname;
    }

    protected void setUseFullClassname(boolean useFullClassname) {
        this.useFullClassname = useFullClassname;
    }

    protected DataSourceCall getDataSource(String id) {
        return new DataSourceCall(id);
    }

    protected ActionCall getAction(String eventId, String id) {
        return new ActionCall(eventId, id);
    }

    class SimplePermission
    implements org.appng.api.model.Permission {
        private Permission permission;

        SimplePermission(Permission permission) {
            this.permission = permission;
        }

        public String getName() {
            return this.permission.getId();
        }

        public String getDescription() {
            return this.permission.getValue();
        }

        public Integer getId() {
            return null;
        }

        public Application getApplication() {
            return TestBase.this.application;
        }
    }

    class SimpleRole
    implements org.appng.api.model.Role {
        private Role role;
        private Set<org.appng.api.model.Permission> permissions = new HashSet<org.appng.api.model.Permission>();
        private Integer id;

        public SimpleRole(Role role, Integer id) {
            this.role = role;
            this.id = id;
        }

        public String getName() {
            return this.role.getName();
        }

        public String getDescription() {
            return this.role.getDescription();
        }

        public Integer getId() {
            return this.id;
        }

        public Application getApplication() {
            return TestBase.this.application;
        }

        public Set<org.appng.api.model.Permission> getPermissions() {
            return this.permissions;
        }
    }

    protected class SimpleFeatureProvider
    implements FeatureProvider {
        private int documentCount = 0;
        private org.appng.api.model.Properties properties;

        SimpleFeatureProvider(org.appng.api.model.Properties properties) {
            this.properties = properties;
        }

        public Consumer<DocumentEvent, DocumentProducer> getIndexer() {
            if (this.properties.getString("featureIndexing", "false").equalsIgnoreCase("true")) {
                return new Consumer<DocumentEvent, DocumentProducer>(){

                    public void put(DocumentProducer element) throws InterruptedException {
                        super.put((Object)element);
                        SimpleFeatureProvider.this.documentCount++;
                    }

                    public boolean put(DocumentProducer element, long timeoutMillis) throws InterruptedException {
                        SimpleFeatureProvider.this.documentCount++;
                        return super.put((Object)element, timeoutMillis);
                    }

                    public void putWithTimeout(DocumentProducer element, long timeoutMillis) throws InterruptedException, TimeoutException {
                        super.putWithTimeout((Object)element, timeoutMillis);
                        SimpleFeatureProvider.this.documentCount++;
                    }
                };
            }
            return null;
        }

        public Integer getDocumentCount() {
            return this.documentCount;
        }

        public ImageProcessor getImageProcessor(File sourceFile, String targetFile) {
            if (this.properties.getString("featureImageProcessing", "false").equalsIgnoreCase("true")) {
                return new ImageProcessor(sourceFile, new File(this.getImageCache(), targetFile));
            }
            return null;
        }

        public File getImageCache() {
            if (this.properties.getString("featureImageProcessing", "false").equalsIgnoreCase("true")) {
                return new File("target/imageCache");
            }
            return null;
        }
    }

    protected class SimpleApplication
    implements Application {
        private String name;
        private ConfigurableApplicationContext context;
        private Map<String, org.appng.api.model.Permission> permissionMap = new HashMap<String, org.appng.api.model.Permission>();
        private Set<org.appng.api.model.Role> roleSet;
        private org.appng.api.model.Properties properties;
        private List<ApplicationSubject> applicationSubjects;
        private SimpleFeatureProvider featureProvider;
        private ApplicationInfo applicationInfo;

        protected SimpleApplication(String name, ConfigurableApplicationContext context) {
            this(name, context, new ArrayList<ApplicationSubject>());
        }

        protected SimpleApplication(String name, ConfigurableApplicationContext context, List<ApplicationSubject> applicationSubjects) {
            this.name = name;
            this.context = context;
            this.applicationSubjects = applicationSubjects;
        }

        protected void init(Properties overrides, ApplicationInfo applicationInfo) {
            this.applicationInfo = applicationInfo;
            for (Object p : applicationInfo.getPermissions().getPermission()) {
                SimplePermission simplePermission = new SimplePermission((Permission)p);
                this.permissionMap.put(p.getId(), simplePermission);
            }
            this.roleSet = new HashSet<org.appng.api.model.Role>();
            int roleId = 1;
            for (Role r : applicationInfo.getRoles().getRole()) {
                SimpleRole role = new SimpleRole(r, roleId++);
                List permission = r.getPermission();
                for (PermissionRef permissionRef : permission) {
                    org.appng.api.model.Permission e = this.permissionMap.get(permissionRef.getId());
                    role.getPermissions().add(e);
                }
                this.roleSet.add(role);
            }
            HashSet<SimpleProperty> props = new HashSet<SimpleProperty>();
            for (Property prop : applicationInfo.getProperties().getProperty()) {
                SimpleProperty property;
                String value;
                String propName = prop.getId();
                String string = value = overrides.containsKey(propName) ? overrides.getProperty(propName) : prop.getValue();
                if (Boolean.TRUE.equals(prop.isClob())) {
                    property = new SimpleProperty(propName, null);
                    property.setClob(value);
                } else {
                    property = new SimpleProperty(propName, value);
                }
                property.setDescription(prop.getDescription());
                props.add(property);
            }
            this.properties = new PropertyHolder("", props);
            this.featureProvider = new SimpleFeatureProvider(this.properties);
        }

        public String getName() {
            return this.name;
        }

        public String getDisplayName() {
            return this.applicationInfo.getDisplayName();
        }

        public String getPackageVersion() {
            return this.applicationInfo.getVersion();
        }

        public String getTimestamp() {
            return this.applicationInfo.getTimestamp();
        }

        public String getLongDescription() {
            return this.applicationInfo.getLongDescription();
        }

        public String getAppNGVersion() {
            return this.applicationInfo.getAppngVersion();
        }

        public boolean isInstalled() {
            return true;
        }

        public boolean isSnapshot() {
            return this.getPackageVersion().endsWith("-SNAPSHOT");
        }

        public String getDescription() {
            return this.applicationInfo.getDescription();
        }

        public Integer getId() {
            return null;
        }

        public Date getVersion() {
            return null;
        }

        public Set<org.appng.api.model.Permission> getPermissions() {
            return new HashSet<org.appng.api.model.Permission>(this.permissionMap.values());
        }

        public Set<org.appng.api.model.Role> getRoles() {
            return this.roleSet;
        }

        public Resources getResources() {
            return TestBase.this.request.getApplicationConfig().getResources();
        }

        public Set<Resource> getResourceSet() {
            return this.getResources().getResources();
        }

        public org.appng.api.model.Properties getProperties() {
            return this.properties;
        }

        public <T> T getBean(String name, Class<T> clazz) {
            return (T)this.context.getBean(name, clazz);
        }

        public String[] getBeanNames(Class<?> clazz) {
            return this.context.getBeanNamesForType(clazz);
        }

        public <T> T getBean(Class<T> clazz) {
            return (T)this.context.getBean(clazz);
        }

        public Object getBean(String beanName) {
            return this.context.getBean(beanName);
        }

        public boolean containsBean(String beanName) {
            return this.context.containsBean(this.name);
        }

        public boolean isFileBased() {
            return true;
        }

        public boolean isPrivileged() {
            return false;
        }

        @Deprecated
        public boolean isCoreApplication() {
            return this.isPrivileged();
        }

        public boolean isHidden() {
            return false;
        }

        public String getMessage(Locale locale, String key, Object ... args) {
            return TestBase.this.messageSource.getMessage(key, args, locale);
        }

        public String getSessionParamKey(Site site) {
            return site.getName() + "." + this.getName();
        }

        public Map<String, String> getSessionParams(Site site, Environment environment) {
            String sessionParamKey = this.getSessionParamKey(site);
            HashMap sessionsParams = (HashMap)environment.getAttribute(Scope.SESSION, sessionParamKey);
            if (null == sessionsParams) {
                sessionsParams = new HashMap();
                environment.setAttribute(Scope.SESSION, sessionParamKey, sessionsParams);
            }
            return sessionsParams;
        }

        public SimpleFeatureProvider getFeatureProvider() {
            return this.featureProvider;
        }

        public List<ApplicationSubject> getApplicationSubjects() {
            return this.applicationSubjects;
        }
    }

    protected class ActionCall
    extends ActionRef {
        private ParametrizedCall parametrizedCall;

        ActionCall(String eventId, String id) {
            this.setEventId(eventId);
            this.setId(id);
            this.setParams(new Params());
            this.parametrizedCall = new ParametrizedCall(super.getParams());
        }

        public Params getParams() {
            return this.parametrizedCall.getParams();
        }

        ParameterSupport getParameterSupport() {
            return this.parametrizedCall.getParameterSupport();
        }

        public ActionCall clearParams() {
            this.parametrizedCall.clearParams();
            return this;
        }

        public ActionCall withParam(String name, String value) {
            this.parametrizedCall.withParam(name, value);
            return this;
        }

        public CallableAction getCallableAction(Object form) throws ProcessingException {
            return new CallableTestAction(TestBase.this.site, TestBase.this.application, TestBase.this.request, this, form);
        }
    }

    protected class DataSourceCall
    extends DatasourceRef {
        private ParametrizedCall parametrizedCall;

        DataSourceCall(String id) {
            this.setId(id);
            this.setParams(new Params());
            this.parametrizedCall = new ParametrizedCall(super.getParams());
        }

        public Params getParams() {
            return this.parametrizedCall.getParams();
        }

        ParameterSupport getParameterSupport() {
            return this.parametrizedCall.getParameterSupport();
        }

        public DataSourceCall clearParams() {
            this.parametrizedCall.clearParams();
            return this;
        }

        public DataSourceCall withParam(String name, String value) {
            this.parametrizedCall.withParam(name, value);
            return this;
        }

        public CallableDataSource getCallableDataSource() throws ProcessingException {
            return new CallableDataSource(TestBase.this.site, TestBase.this.application, TestBase.this.request, this.getParameterSupport(), (DatasourceRef)this);
        }
    }

    class ParametrizedCall {
        private Map<String, String> configParams = new HashMap<String, String>();
        private Params params;

        ParametrizedCall(Params params) {
            this.params = params;
        }

        Params getParams() {
            for (String key : this.configParams.keySet()) {
                Param param = new Param();
                param.setName(key);
                param.setValue(this.configParams.get(key));
                this.params.getParam().add(param);
            }
            return this.params;
        }

        ParameterSupport getParameterSupport() {
            return new DollarParameterSupport(this.configParams);
        }

        ParametrizedCall clearParams() {
            this.configParams.clear();
            this.getParams().getParam().clear();
            return this;
        }

        ParametrizedCall withParam(String name, String value) {
            this.configParams.put(name, value);
            return this;
        }
    }

    class CallableTestAction
    extends CallableAction {
        private Object form;

        public CallableTestAction(Site site, Application application, ApplicationRequest applicationRequest, ActionRef actionRef, Object form) throws ProcessingException {
            super(site, application, applicationRequest, actionRef);
            this.form = form;
        }

        protected Object getBindObject(FieldProcessor fieldProcessor) throws BusinessException {
            if (null != this.form) {
                BeanWrapperImpl original = new BeanWrapperImpl(this.form);
                BeanWrapperImpl copy = new BeanWrapperImpl(this.form.getClass());
                for (FieldDef fieldDef : fieldProcessor.getMetaData().getFields()) {
                    copy.setPropertyValue(fieldDef.getBinding(), original.getPropertyValue(fieldDef.getBinding()));
                }
                return copy.getWrappedInstance();
            }
            return null;
        }
    }
}

