/*
 * Decompiled with CFR 0.152.
 */
package org.appng.testsupport.persistence;

import org.hsqldb.Server;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.InitializingBean;

public class HsqlServerFactoryBean
implements FactoryBean<Server>,
InitializingBean {
    private static final Logger LOG = LoggerFactory.getLogger(HsqlServerFactoryBean.class);
    private String databaseName = "hsql-testdb";
    private int port = 9001;
    private String databasePath;
    private Server server;

    public Server getObject() throws Exception {
        return this.server;
    }

    public Class<?> getObjectType() {
        return Server.class;
    }

    public boolean isSingleton() {
        return true;
    }

    public void destroy() {
        this.server.stop();
        LOG.debug("Server stopped:" + this.toString());
    }

    public void init() {
        this.server.start();
        LOG.debug("Server started:" + this.toString());
    }

    public void afterPropertiesSet() throws Exception {
        this.server = new Server();
        this.server.setLogWriter(null);
        this.server.setSilent(true);
        this.server.setNoSystemExit(true);
        this.server.setDatabaseName(0, this.getDatabaseName());
        this.server.setDatabasePath(0, this.getDatabasePath());
        this.server.setPort(this.getPort());
        this.server.setTrace(false);
    }

    public String getDatabaseName() {
        return this.databaseName;
    }

    public void setDatabaseName(String databaseName) {
        this.databaseName = databaseName;
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public String getDatabasePath() {
        return null == this.databasePath ? "file:target/hsql/" + this.databaseName : this.databasePath;
    }

    public void setDatabasePath(String databasePath) {
        if (null != databasePath) {
            this.databasePath = databasePath;
        }
    }

    public String toString() {
        return "database " + this.getDatabaseName() + " at port " + this.port + " (" + this.getDatabasePath() + ")";
    }
}

