/*
 * Decompiled with CFR 0.152.
 */
package org.appng.search.indexer;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.text.StringEscapeUtils;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.nodes.Node;
import org.jsoup.nodes.TextNode;
import org.jsoup.select.Elements;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ParseTags {
    private static final Logger LOGGER = LoggerFactory.getLogger(ParseTags.class);
    private static final char NBSP = '\u00a0';
    private static final char BLANK = ' ';
    private static final String ATTR_FIELD = "field";
    private static final String ATTR_INDEX = "index";
    private static final String SEARCHABLE = "searchable";
    private String tagPrefix;

    public ParseTags(String tagPrefix) {
        this.tagPrefix = tagPrefix;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Map<String, StringBuilder> parse(InputStream is) throws IOException {
        try (InputStream inner = is;){
            HashMap<String, StringBuilder> fieldMap = new HashMap<String, StringBuilder>();
            Document doc = Jsoup.parse((InputStream)inner, null, (String)"");
            Elements searchables = doc.getElementsByTag(this.tagPrefix + ":" + SEARCHABLE);
            ArrayList<Node> skipped = new ArrayList<Node>();
            for (Element node : searchables) {
                StringBuilder content;
                if (!this.append(skipped, (Node)node, content = new StringBuilder())) continue;
                String field = node.attr(ATTR_FIELD);
                if (!fieldMap.containsKey(field)) {
                    fieldMap.put(field, content);
                    continue;
                }
                StringBuilder existingBuffer = (StringBuilder)fieldMap.get(field);
                existingBuffer.append(content.toString().trim());
            }
            HashMap<String, StringBuilder> hashMap = fieldMap;
            return hashMap;
        }
    }

    private boolean doIndex(List<Node> skipped, Node node) {
        if (node instanceof Element) {
            Element element;
            Element parent = element = (Element)node;
            boolean skip = false;
            String nodeName = element.nodeName();
            while (null != (parent = parent.parent())) {
                if (!skipped.contains(parent)) continue;
                skip = true;
                LOGGER.trace("skipping {} field = {}", (Object)nodeName, (Object)element.attr(ATTR_FIELD));
                break;
            }
            String index = element.attr(ATTR_INDEX);
            return !skip && (!nodeName.equalsIgnoreCase(this.tagPrefix + ":" + SEARCHABLE) || "true".equalsIgnoreCase(index));
        }
        return false;
    }

    private boolean append(List<Node> skipped, Node node, StringBuilder content) {
        boolean doAppend = false;
        if (!skipped.contains(node)) {
            doAppend = this.doIndex(skipped, node);
            if (doAppend) {
                for (Node child : node.childNodes()) {
                    if (child instanceof TextNode) {
                        String text = child.toString();
                        if (content.lastIndexOf(" ") != content.length() - 1) {
                            content.append(" ");
                        }
                        String unescaped = StringEscapeUtils.unescapeHtml4((String)text);
                        content.append(unescaped.trim().replace('\u00a0', ' '));
                    }
                    this.append(skipped, child, content);
                }
                String tagName = this.tagPrefix + ":" + SEARCHABLE;
                if (node.nodeName().equalsIgnoreCase(tagName)) {
                    String field = node.attr(ATTR_FIELD);
                    LOGGER.trace("adding {} field = '{}'", (Object)tagName, (Object)field);
                }
            } else {
                skipped.add(node);
            }
        }
        return doAppend;
    }

    protected Map<String, StringBuilder> parse(File file) throws IOException {
        LOGGER.debug("parsing {}", (Object)file.getAbsolutePath());
        return this.parse(new FileInputStream(file));
    }
}

