/*
 * Decompiled with CFR 0.152.
 */
package org.appng.search.indexer;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.SortedSet;
import java.util.TreeSet;
import org.apache.commons.lang3.StringUtils;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.index.IndexWriterConfig;
import org.appng.search.Search;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IndexConfig {
    private static final Logger LOGGER = LoggerFactory.getLogger(IndexConfig.class);
    private static final String SLASH = "/";
    private List<ConfigEntry> entries = new ArrayList<ConfigEntry>();
    private Map<String, ConfigEntry> entryMap = new HashMap<String, ConfigEntry>();
    private IndexWriterConfig.OpenMode openMode;
    private String tagPrefix;

    public IndexConfig(String tagPrefix) {
        this.tagPrefix = tagPrefix;
    }

    public static IndexConfig getInstance(String configString, String tagPrefix) {
        String[] splitted = StringUtils.split((String)configString, (String)"|");
        return IndexConfig.getInstance(Arrays.asList(splitted), tagPrefix);
    }

    public static IndexConfig getInstance(List<String> configEntries, String tagPrefix) {
        IndexConfig config = new IndexConfig(tagPrefix);
        for (String line : configEntries) {
            String[] splitted = StringUtils.split((String)line, (String)";");
            String folder = splitted[0].trim();
            if (!folder.startsWith(SLASH)) {
                folder = folder + SLASH;
            }
            String language = splitted[1].trim();
            String analyzerClass = splitted[2].trim();
            config.addEntry(folder, language, analyzerClass);
        }
        return config;
    }

    public SortedSet<String> getFolders() {
        TreeSet<String> folders = new TreeSet<String>();
        folders.addAll(this.entryMap.keySet());
        return folders;
    }

    public ConfigEntry getEntry(String folder) {
        return this.entryMap.get(folder);
    }

    public void addEntry(String folder, String language, String analyzerClass) {
        ConfigEntry entry = new ConfigEntry(folder, language, analyzerClass);
        this.entryMap.put(entry.getFolder(), entry);
        this.entries.add(entry);
    }

    public IndexWriterConfig.OpenMode getOpenMode() {
        return this.openMode;
    }

    public void setOpenMode(IndexWriterConfig.OpenMode openMode) {
        this.openMode = openMode;
    }

    public String getTagPrefix() {
        return this.tagPrefix;
    }

    public class ConfigEntry {
        private final String folder;
        private final String language;
        private final String analyzerClass;

        public ConfigEntry(String folder, String language, String analyzerClass) {
            this.folder = folder;
            this.language = language;
            this.analyzerClass = analyzerClass;
        }

        public Analyzer getAnalyzer() {
            Analyzer analyzer = null;
            Class<?> clazz = null;
            try {
                clazz = Class.forName(this.analyzerClass);
            }
            catch (ClassNotFoundException e1) {
                String className = "org.apache.lucene.analysis." + this.getFolder().replaceAll(IndexConfig.SLASH, "") + "." + this.analyzerClass;
                LOGGER.info("could not find analyzer class '{}', trying '{}'", (Object)this.analyzerClass, (Object)className);
                try {
                    clazz = Class.forName(className);
                }
                catch (ClassNotFoundException e2) {
                    LOGGER.info("could not find analyzer class '{}', trying '{}'", (Object)this.analyzerClass, (Object)className);
                }
            }
            if (null != clazz) {
                try {
                    return (Analyzer)clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                }
                catch (Exception e) {
                    LOGGER.warn("could not instanciate class '{}'", (Object)clazz.getName());
                }
            }
            if (null == analyzer) {
                LOGGER.info("no analyzer found for folder '{}', using default {}", (Object)this.getFolder(), (Object)Search.getDefaultAnalyzerClass().getName());
                analyzer = Search.getDefaultAnalyzer();
            }
            return analyzer;
        }

        public String getFolder() {
            return this.folder;
        }

        public String getLanguage() {
            return this.language;
        }

        public String getAnalyzerClass() {
            return this.analyzerClass;
        }
    }
}

