/*
 * Decompiled with CFR 0.152.
 */
package org.appng.search.indexer;

import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.io.Reader;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.SortedSet;
import java.util.concurrent.TimeoutException;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.IOUtils;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.TextField;
import org.apache.lucene.index.IndexableField;
import org.apache.tika.parser.ParsingReader;
import org.appng.api.model.Application;
import org.appng.api.model.Site;
import org.appng.api.search.Document;
import org.appng.api.search.DocumentEvent;
import org.appng.api.search.DocumentProducer;
import org.appng.api.search.Producer;
import org.appng.search.DocumentProvider;
import org.appng.search.Search;
import org.appng.search.indexer.DocumentIndexer;
import org.appng.search.indexer.IndexConfig;
import org.appng.search.indexer.ParseTags;
import org.appng.search.indexer.SimpleDocument;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileSystemProvider
implements DocumentProvider {
    private static final Logger LOGGER = LoggerFactory.getLogger(FileSystemProvider.class);
    private IndexConfig config;
    private List<String> extensions;
    private long timeout;
    private String jspExtension;
    private File dataDir;
    private Collection<? extends File> protectedFolders;
    private static final String INDEX_PAGE = "indexPage";

    public FileSystemProvider(IndexConfig config, List<String> extensions, long timeout, String jspExtension, File dataDir, Collection<? extends File> protectedFolders) {
        this.config = config;
        this.extensions = extensions;
        this.timeout = timeout;
        this.jspExtension = jspExtension;
        this.dataDir = dataDir;
        this.protectedFolders = protectedFolders;
    }

    @Override
    public Iterable<DocumentProducer> getDocumentProducers(Site site, Application application) throws InterruptedException, TimeoutException {
        return this.indexDirectory(site.getProperties().getInteger("indexFileSystemQueueSize"));
    }

    public Iterable<DocumentProducer> indexDirectory(int documentQueueSize) throws InterruptedException, TimeoutException {
        ArrayList<DocumentProducer> producers = new ArrayList<DocumentProducer>();
        LOGGER.info("dataDir: {}", (Object)this.dataDir.getPath());
        DocumentProducer clearer = new DocumentProducer(1, Search.getDefaultAnalyzerClass(), "clear index");
        clearer.put((Object)new DocumentEvent(null, DocumentIndexer.CLEAR_INDEX), this.timeout);
        producers.add(clearer);
        int numIndexed = 0;
        long start = System.currentTimeMillis();
        if (!this.dataDir.exists() || !this.dataDir.isDirectory()) {
            LOGGER.error("{} does not exist or is not a directory", (Object)this.dataDir);
        } else {
            SortedSet<String> folders = this.config.getFolders();
            for (String folder : folders) {
                ArrayList<File> skippedFolders = new ArrayList<File>(this.protectedFolders);
                ArrayList<String> skipList = new ArrayList<String>(folders);
                skipList.remove(folder);
                for (String skipfolder : skipList) {
                    skippedFolders.add(new File(this.dataDir, skipfolder));
                }
                IndexConfig.ConfigEntry entry = this.config.getEntry(folder);
                File contentFolder = new File(this.dataDir, folder);
                if (contentFolder.exists()) {
                    DocumentProducer documentProducer = new DocumentProducer(documentQueueSize, entry.getAnalyzer().getClass(), "index " + contentFolder.getAbsolutePath());
                    String language = entry.getLanguage();
                    numIndexed += this.indexDirectory((Producer<DocumentEvent>)documentProducer, language, contentFolder, this.dataDir, this.extensions, skippedFolders);
                    producers.add(documentProducer);
                    continue;
                }
                LOGGER.warn("The folder {} does not exist, probably the site property {} is misconfigured!", (Object)contentFolder.getAbsolutePath(), (Object)"indexConfig");
            }
        }
        long end = System.currentTimeMillis();
        LOGGER.info("Indexing {} files took {} milliseconds", (Object)numIndexed, (Object)(end - start));
        return producers;
    }

    private int indexDirectory(Producer<DocumentEvent> producer, String language, File currentDirectory, File dataDir, final List<String> fileTypes, List<File> protectedFolders) throws InterruptedException, TimeoutException {
        int count = 0;
        File[] fileArr = currentDirectory.listFiles(new FileFilter(){

            @Override
            public boolean accept(File pathname) {
                boolean accept = pathname.isDirectory() || FilenameUtils.isExtension((String)pathname.getAbsolutePath(), (Collection)fileTypes);
                return accept;
            }
        });
        if (null != fileArr) {
            int pathOffset = dataDir.getAbsolutePath().length();
            for (int i = 0; i < fileArr.length; ++i) {
                File file = fileArr[i];
                if (file.isDirectory()) {
                    if (protectedFolders.contains(file)) continue;
                    count += this.indexDirectory(producer, language, file, dataDir, fileTypes, protectedFolders);
                    continue;
                }
                String filePath = file.getAbsolutePath().substring(pathOffset);
                DocumentEvent documentEvent = this.indexFile(i + 1, fileArr.length, language, file, filePath = filePath.replace("\\", "/"));
                if (null == documentEvent) continue;
                producer.putWithTimeout((Object)documentEvent, this.timeout);
                ++count;
            }
        }
        return count;
    }

    DocumentEvent indexFile(int fileNo, int total, String language, File file, String serverPath) throws InterruptedException, TimeoutException {
        String content;
        SimpleDocument document;
        long start;
        block20: {
            start = System.currentTimeMillis();
            document = new SimpleDocument();
            document.setPath(serverPath);
            String extension = FilenameUtils.getExtension((String)file.getName());
            document.setType(extension);
            document.setDate(new Date(file.lastModified()));
            document.setLanguage(language);
            content = null;
            try {
                if (this.jspExtension.equals(extension)) {
                    Map<String, StringBuilder> fieldMap = new ParseTags(this.config.getTagPrefix()).parse(file);
                    StringBuilder indexPage = fieldMap.remove(INDEX_PAGE);
                    if (indexPage == null || !"false".equalsIgnoreCase(indexPage.toString())) {
                        StringBuilder field = fieldMap.remove("contents");
                        if (null != field) {
                            content = field.toString();
                        }
                        if (null != (field = fieldMap.remove("title"))) {
                            document.setName(field.toString());
                        }
                        for (String name : fieldMap.keySet()) {
                            TextField customField = new TextField(name, fieldMap.get(name).toString(), Field.Store.YES);
                            document.addField((IndexableField)customField);
                        }
                        LOGGER.debug("indexing ({}/{}):{}", new Object[]{fileNo, total, file.getAbsolutePath()});
                    } else {
                        LOGGER.debug("skipping {}", (Object)file.getAbsolutePath());
                    }
                    break block20;
                }
                try (ParsingReader parsingReader = new ParsingReader(file);){
                    LOGGER.debug("indexing ({}/{}):{}", new Object[]{fileNo, total, file.getAbsolutePath()});
                    byte[] bytes = IOUtils.toByteArray((Reader)parsingReader, (Charset)Charset.defaultCharset());
                    content = new String(bytes);
                    document.setName(FilenameUtils.getName((String)file.getName()));
                }
            }
            catch (IOException e) {
                LOGGER.error(String.format("error while indexing %s", file.getAbsolutePath()), (Throwable)e);
                return null;
            }
        }
        document.setContent(content);
        document.setId(serverPath);
        long duration = System.currentTimeMillis() - start;
        LOGGER.trace("extraction took {}ms", (Object)duration);
        return new DocumentEvent((Document)document, Document.CREATE);
    }
}

