/*
 * Decompiled with CFR 0.152.
 */
package org.appng.search.indexer;

import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.util.Date;
import org.apache.commons.lang3.time.FastDateFormat;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.StringField;
import org.apache.lucene.document.TextField;
import org.apache.lucene.index.IndexableField;
import org.appng.api.observe.Observable;
import org.appng.api.search.Consumer;
import org.appng.api.search.Document;
import org.appng.api.search.DocumentEvent;
import org.appng.api.search.DocumentProducer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DocumentIndexer
extends Consumer<DocumentEvent, DocumentProducer>
implements Runnable {
    private static final Logger LOGGER = LoggerFactory.getLogger(DocumentIndexer.class);
    private static final String YYYY_MM_DD_HH_MM_SS = "yyyy-MM-dd HH:mm:ss";
    public static final Observable.Event CLEAR_INDEX = new Observable.Event("clear-index");
    private static final FastDateFormat DATEFORMAT = FastDateFormat.getInstance((String)"yyyy-MM-dd HH:mm:ss");
    private File indexDir;
    private Long timeout;

    public DocumentIndexer(int queueSize, File indexDir, Long timeout) {
        super(queueSize);
        this.indexDir = indexDir;
        this.timeout = timeout;
    }

    public DocumentIndexer(File indexDir, Long timeout) {
        this.indexDir = indexDir;
        this.timeout = timeout;
    }

    /*
     * Exception decompiling
     */
    @Override
    public void run() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void close(Closeable ... closeables) {
        for (Closeable closeable : closeables) {
            if (null == closeable) continue;
            try {
                closeable.close();
                LOGGER.debug("closed {}", (Object)closeable);
            }
            catch (IOException e) {
                LOGGER.debug(String.format("error closing %s", closeable), (Throwable)e);
            }
            finally {
                closeable = null;
            }
        }
    }

    private org.apache.lucene.document.Document getDocument(Document document) {
        org.apache.lucene.document.Document indexDoc = new org.apache.lucene.document.Document();
        this.addStringField(indexDoc, "id", document.getId(), Field.Store.YES);
        this.addTextField(indexDoc, "title", document.getName(), Field.Store.YES);
        this.addStringField(indexDoc, "path", document.getPath(), Field.Store.YES);
        this.addTextField(indexDoc, "teaser", document.getDescription(), Field.Store.YES);
        Date dueDate = document.getDate();
        if (null != dueDate) {
            this.addStringField(indexDoc, "date", DATEFORMAT.format(dueDate), Field.Store.YES);
        }
        this.addTextField(indexDoc, "contents", document.getContent(), Field.Store.YES);
        this.addStringField(indexDoc, "type", document.getType(), Field.Store.YES);
        this.addStringField(indexDoc, "language", document.getLanguage(), Field.Store.YES);
        if (document.getAdditionalFields() != null) {
            for (IndexableField field : document.getAdditionalFields()) {
                indexDoc.add(field);
            }
        }
        return indexDoc;
    }

    private void addTextField(org.apache.lucene.document.Document indexDoc, String name, String value, Field.Store store) {
        if (null != value) {
            indexDoc.add((IndexableField)new TextField(name, value, store));
        }
    }

    private void addStringField(org.apache.lucene.document.Document indexDoc, String name, String value, Field.Store store) {
        if (null != value) {
            indexDoc.add((IndexableField)new StringField(name, value, store));
        }
    }
}

