/*
 * Decompiled with CFR 0.152.
 */
package org.appng.search.indexer;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeoutException;
import org.appng.api.model.Application;
import org.appng.api.model.Properties;
import org.appng.api.model.Site;
import org.appng.api.search.Consumer;
import org.appng.api.search.DocumentEvent;
import org.appng.api.search.DocumentProducer;
import org.appng.search.DocumentProvider;
import org.appng.search.indexer.FileSystemProvider;
import org.appng.search.indexer.IndexConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GlobalIndexer {
    private static final Logger LOGGER = LoggerFactory.getLogger(GlobalIndexer.class);
    private Consumer<DocumentEvent, DocumentProducer> indexer;

    public GlobalIndexer(Consumer<DocumentEvent, DocumentProducer> indexer) {
        this.indexer = indexer;
    }

    public void doIndex(Site site, String jspType) {
        LOGGER.debug("start indexing for site {}", (Object)site.getName());
        Properties properties = site.getProperties();
        String sitePath = properties.getString("siteRootDir");
        String seData = sitePath + properties.getString("wwwDir");
        File dataDir = new File(seData).getAbsoluteFile();
        String indexConfig = properties.getString("indexConfig");
        String tagPrefix = properties.getString("tagPrefix");
        IndexConfig config = IndexConfig.getInstance(indexConfig, tagPrefix);
        Integer timeout = properties.getInteger("indexTimeout", Integer.valueOf(5000));
        List extensions = site.getProperties().getList("indexFileTypes", ",");
        FileSystemProvider fileSystemProvider = new FileSystemProvider(config, extensions, timeout.intValue(), jspType, dataDir, new ArrayList());
        this.processProducer(site, null, fileSystemProvider, timeout);
        for (Application application : site.getApplications()) {
            String[] documentProviders;
            for (String documentProviderName : documentProviders = application.getBeanNames(DocumentProvider.class)) {
                DocumentProvider documentProvider = (DocumentProvider)application.getBean(documentProviderName, DocumentProvider.class);
                int processed = this.processProducer(site, application, documentProvider, timeout);
                LOGGER.debug("processed {}  from application {} wich returned {} DocumentProducers", new Object[]{documentProvider.getClass().getName(), application.getName(), processed});
            }
        }
    }

    private int processProducer(Site site, Application application, DocumentProvider documentProvider, Integer timeout) {
        try {
            Iterable<DocumentProducer> documentProducers = documentProvider.getDocumentProducers(site, application);
            return this.putWithTimeout(documentProducers, timeout);
        }
        catch (InterruptedException | TimeoutException e) {
            LOGGER.error(String.format("error while processing %s", documentProvider.getClass().getName()), (Throwable)e);
            return 0;
        }
    }

    private int putWithTimeout(Iterable<DocumentProducer> producers, Integer timeout) {
        int count = 0;
        if (null != producers) {
            for (DocumentProducer producer : producers) {
                try {
                    this.indexer.putWithTimeout((Object)producer, (long)timeout.intValue());
                    ++count;
                }
                catch (InterruptedException | TimeoutException e) {
                    LOGGER.error(String.format("error processing %s", producer), (Throwable)e);
                }
            }
        }
        return count;
    }
}

