/*
 * Decompiled with CFR 0.152.
 */
package org.appng.search.searcher;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.index.DirectoryReader;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.Term;
import org.apache.lucene.queryparser.classic.MultiFieldQueryParser;
import org.apache.lucene.queryparser.classic.ParseException;
import org.apache.lucene.queryparser.classic.QueryParser;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.Collector;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.ScoreDoc;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.search.TopScoreDocCollector;
import org.apache.lucene.store.Directory;
import org.appng.api.Environment;
import org.appng.api.model.Application;
import org.appng.api.model.Site;
import org.appng.api.search.Document;
import org.appng.search.SearchProvider;
import org.appng.search.indexer.SimpleDocument;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StandardSearcher
implements SearchProvider {
    private static final Logger LOGGER = LoggerFactory.getLogger(StandardSearcher.class);
    private static final String PARAM_EXCLUDE_TYPES = "excludeTypes";
    private static final String PARAM_TERM_TRANSFORM = "termTransform";
    private static final String DEFAULT_TERM_TRANSFORM = "term term*";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Iterable<Document> doSearch(Environment env, Site site, Application application, Directory directory, String term, String language, String[] parseFields, Analyzer analyzer, String highlightWith, Map<String, String> parameters) throws IOException {
        ArrayList<Document> docs = new ArrayList<Document>();
        DirectoryReader reader = null;
        try {
            ScoreDoc[] hits;
            reader = DirectoryReader.open((Directory)directory);
            IndexSearcher searcher = new IndexSearcher((IndexReader)reader);
            String[] excludeTypes = StringUtils.split((String)parameters.get(PARAM_EXCLUDE_TYPES), (char)',');
            String searchTermTransform = parameters.get(PARAM_TERM_TRANSFORM);
            if (StringUtils.isBlank((CharSequence)searchTermTransform)) {
                searchTermTransform = DEFAULT_TERM_TRANSFORM;
            }
            String transformedTerm = this.getSearchTerm(term, searchTermTransform);
            Query query = this.getQuery(parseFields, transformedTerm, analyzer, language, excludeTypes);
            TopScoreDocCollector collector = TopScoreDocCollector.create((int)100);
            searcher.search(query, (Collector)collector);
            for (ScoreDoc scoreDoc : hits = collector.topDocs().scoreDocs) {
                org.apache.lucene.document.Document doc = searcher.doc(scoreDoc.doc);
                SimpleDocument simpleDoc = SimpleDocument.extract(doc, scoreDoc.doc, scoreDoc.score);
                simpleDoc.setFragment("contents", analyzer, query, highlightWith);
                docs.add(simpleDoc);
            }
            LOGGER.info("{} results returned from query: {}", (Object)docs.size(), (Object)query);
        }
        catch (ParseException e) {
            LOGGER.error("error performing search", (Throwable)e);
        }
        finally {
            if (null != reader) {
                reader.close();
            }
        }
        return docs;
    }

    protected Query getQuery(String[] parseFields, String searchTerm, Analyzer analyzer, String language, String[] excludeTypes) throws ParseException {
        BooleanQuery.Builder booleanQuery = new BooleanQuery.Builder();
        if (null != language) {
            TermQuery langQuery = new TermQuery(new Term("language", language));
            booleanQuery.add((Query)langQuery, BooleanClause.Occur.MUST);
        }
        Query query = new MultiFieldQueryParser(parseFields, analyzer).parse(searchTerm);
        booleanQuery.add(query, BooleanClause.Occur.MUST);
        if (null != excludeTypes) {
            for (String type : excludeTypes) {
                Term tq = new Term("type", type.trim());
                booleanQuery.add((Query)new TermQuery(tq), BooleanClause.Occur.MUST_NOT);
            }
        }
        return booleanQuery.build();
    }

    public String getSearchTerm(String searchTerm, String searchTermTransform) {
        searchTerm = QueryParser.escape((String)StringUtils.trim((String)searchTerm));
        if (StringUtils.isNotBlank((CharSequence)searchTermTransform)) {
            searchTerm = searchTermTransform.replaceAll("term", searchTerm.replace("\\", "\\\\"));
        }
        return searchTerm;
    }
}

