/*
 * Decompiled with CFR 0.152.
 */
package org.appng.search.indexer;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.time.FastDateFormat;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.highlight.Formatter;
import org.apache.lucene.search.highlight.Highlighter;
import org.apache.lucene.search.highlight.QueryScorer;
import org.apache.lucene.search.highlight.Scorer;
import org.apache.lucene.search.highlight.SimpleHTMLFormatter;
import org.appng.api.observe.Observable;
import org.appng.api.observe.Observer;
import org.appng.api.observe.impl.ObservableDelegate;
import org.appng.api.search.Document;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.safety.Whitelist;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SimpleDocument
implements Document {
    private static final Logger LOG = LoggerFactory.getLogger(SimpleDocument.class);
    public static final FastDateFormat DATEFORMAT = FastDateFormat.getInstance((String)"yyyy-MM-dd HH:mm:ss");
    private Observable<Document> observable = new ObservableDelegate((Observable)this);
    private String language;
    private String type;
    private String content;
    private String path;
    private String image;
    private String description;
    private Date date;
    private String name;
    private String id;
    private int docId = -1;
    private float score = -1.0f;
    private String fragment;
    private Map<String, IndexableField> fields = new HashMap<String, IndexableField>();

    public SimpleDocument() {
    }

    public SimpleDocument(float score) {
        this();
        this.score = score;
    }

    public boolean addObserver(Observer<? super Document> observer) {
        return this.observable.addObserver(observer);
    }

    public boolean removeObserver(Observer<? super Document> observer) {
        return this.observable.removeObserver(observer);
    }

    public void notifyObservers(Observable.Event event) {
        this.observable.notifyObservers(event);
    }

    @JsonIgnore
    public Iterable<IndexableField> getAdditionalFields() {
        return this.fields.values();
    }

    public void addField(IndexableField field) {
        this.fields.put(field.name(), field);
    }

    public IndexableField getField(String name) {
        return this.fields.get(name);
    }

    @JsonIgnore
    public Observable<Document> getObservable() {
        return this.observable;
    }

    public void setObservable(Observable<Document> observable) {
        this.observable = observable;
    }

    public String getLanguage() {
        return this.language;
    }

    public void setLanguage(String language) {
        this.language = language;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getContent() {
        return this.content;
    }

    public void setContent(String content) {
        this.content = content;
    }

    public String getPath() {
        return this.path;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public String getImage() {
        return this.image;
    }

    public void setImage(String image) {
        this.image = image;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public Date getDate() {
        return this.date;
    }

    public void setDate(Date date) {
        this.date = date;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public int getDocId() {
        return this.docId;
    }

    public void setDocId(int docId) {
        this.docId = docId;
    }

    public float getScore() {
        return this.score;
    }

    public void setScore(float score) {
        this.score = score;
    }

    public String getFragment() {
        return this.fragment;
    }

    public void setFragment(String fragment) {
        this.fragment = fragment;
    }

    public int compareTo(Document other) {
        return Float.valueOf(other.getScore()).compareTo(Float.valueOf(this.score));
    }

    public static SimpleDocument extract(org.apache.lucene.document.Document doc, int docId, float score) {
        SimpleDocument simpleDoc = new SimpleDocument(score);
        ArrayList<IndexableField> fields = new ArrayList<IndexableField>(doc.getFields());
        simpleDoc.setDocId(docId);
        simpleDoc.setContent(SimpleDocument.getStringFromField(doc, "contents", fields));
        simpleDoc.setDescription(SimpleDocument.getStringFromField(doc, "teaser", fields));
        simpleDoc.setId(SimpleDocument.getStringFromField(doc, "id", fields));
        simpleDoc.setLanguage(SimpleDocument.getStringFromField(doc, "language", fields));
        simpleDoc.setName(SimpleDocument.getStringFromField(doc, "title", fields));
        simpleDoc.setPath(SimpleDocument.getStringFromField(doc, "path", fields));
        simpleDoc.setImage(SimpleDocument.getStringFromField(doc, "image", fields));
        simpleDoc.setType(SimpleDocument.getStringFromField(doc, "type", fields));
        String dateString = SimpleDocument.getStringFromField(doc, "date", fields);
        if (null != dateString) {
            try {
                simpleDoc.setDate(DATEFORMAT.parse(dateString));
            }
            catch (ParseException e) {
                LOG.error("error parsing date", (Throwable)e);
            }
        }
        for (IndexableField field : fields) {
            simpleDoc.addField(field);
        }
        return simpleDoc;
    }

    private static String getStringFromField(org.apache.lucene.document.Document doc, String name, List<IndexableField> fieldsList) {
        IndexableField field = SimpleDocument.getField(doc, name, fieldsList);
        return null == field ? null : field.stringValue();
    }

    protected static Number getNumberFromField(org.apache.lucene.document.Document doc, String name, List<IndexableField> fieldsList) {
        IndexableField field = SimpleDocument.getField(doc, name, fieldsList);
        return null == field ? (Number)null : (Number)field.numericValue();
    }

    private static IndexableField getField(org.apache.lucene.document.Document doc, String name, List<IndexableField> fieldsList) {
        IndexableField field = doc.getField(name);
        fieldsList.remove(field);
        return field;
    }

    public void setFragment(String field, Analyzer analyzer, Query query, String highlightWith) {
        SimpleDocument.setFragment(this, field, analyzer, query, highlightWith);
    }

    public static void setFragment(SimpleDocument doc, String field, Analyzer analyzer, Query query, String highlightWith) {
        if (StringUtils.isNotBlank((CharSequence)doc.getContent()) && StringUtils.isNotBlank((CharSequence)highlightWith)) {
            try {
                SimpleHTMLFormatter formatter = new SimpleHTMLFormatter("<" + highlightWith + ">", "</" + highlightWith + ">");
                QueryScorer queryScorer = new QueryScorer(query);
                Highlighter highlighter = new Highlighter((Formatter)formatter, (Scorer)queryScorer);
                TokenStream tokenStream = analyzer.tokenStream(field, doc.getContent());
                String fragment = highlighter.getBestFragments(tokenStream, doc.getContent(), 3, "...");
                fragment = Jsoup.clean((String)fragment, (String)"", (Whitelist)new Whitelist().addTags(new String[]{highlightWith}), (Document.OutputSettings)new Document.OutputSettings().prettyPrint(false));
                doc.setFragment(fragment);
            }
            catch (Exception e) {
                LOG.warn("error while extracting fragment", (Throwable)e);
            }
        }
    }
}

