/*
 * Decompiled with CFR 0.152.
 */
package org.appng.search.indexer;

import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.nio.file.Path;
import java.util.Date;
import org.apache.commons.lang3.time.FastDateFormat;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.StringField;
import org.apache.lucene.document.TextField;
import org.apache.lucene.index.DirectoryReader;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.IndexWriterConfig;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.search.TopDocs;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.FSDirectory;
import org.appng.api.observe.Observable;
import org.appng.api.search.Consumer;
import org.appng.api.search.Document;
import org.appng.api.search.DocumentEvent;
import org.appng.api.search.DocumentProducer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DocumentIndexer
extends Consumer<DocumentEvent, DocumentProducer>
implements Runnable {
    private static final Logger logger = LoggerFactory.getLogger(DocumentIndexer.class);
    private static final String YYYY_MM_DD_HH_MM_SS = "yyyy-MM-dd HH:mm:ss";
    public static final Observable.Event CLEAR_INDEX = new Observable.Event("clear-index");
    private static final FastDateFormat DATEFORMAT = FastDateFormat.getInstance((String)"yyyy-MM-dd HH:mm:ss");
    private File indexDir;
    private Long timeout;

    public DocumentIndexer(int queueSize, File indexDir, Long timeout) {
        super(queueSize);
        this.indexDir = indexDir;
        this.timeout = timeout;
    }

    public DocumentIndexer(File indexDir, Long timeout) {
        this.indexDir = indexDir;
        this.timeout = timeout;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @Override
    public void run() {
        FSDirectory directory = null;
        Object indexWriter = null;
        DirectoryReader reader = null;
        IndexSearcher searcher = null;
        Analyzer analyzer = null;
        boolean needsRollback = false;
        try {
            while (true) {
                DocumentProducer producer = (DocumentProducer)this.get();
                Constructor constructor = producer.getAnalyzerClass().getConstructor(new Class[0]);
                analyzer = (Analyzer)constructor.newInstance(new Object[0]);
                IndexWriterConfig config = new IndexWriterConfig(analyzer);
                directory = FSDirectory.open((Path)this.indexDir.toPath());
                indexWriter = new IndexWriter((Directory)directory, config);
                needsRollback = true;
                logger.debug("opened IndexWriter#" + indexWriter.hashCode() + " with Analyzer " + analyzer.getClass());
                reader = DirectoryReader.open((IndexWriter)indexWriter);
                searcher = new IndexSearcher((IndexReader)reader);
                int before = indexWriter.numDocs();
                DocumentEvent documentEvent = null;
                int created = 0;
                int updated = 0;
                int deleted = 0;
                while (null != (documentEvent = (DocumentEvent)producer.get(this.timeout.longValue()))) {
                    Observable.Event event = documentEvent.getEvent();
                    if (CLEAR_INDEX.equals((Object)event)) {
                        indexWriter.deleteAll();
                        logger.info("clearing index at " + this.indexDir.getAbsolutePath());
                        continue;
                    }
                    long start = System.currentTimeMillis();
                    Document document = documentEvent.getDocument();
                    org.apache.lucene.document.Document luceneDocument = this.getDocument(document);
                    TermQuery idQuery = new TermQuery(new Term("id", document.getId()));
                    TermQuery typeQuery = new TermQuery(new Term("type", document.getType()));
                    BooleanQuery.Builder queryBuilder = new BooleanQuery.Builder();
                    queryBuilder.add((Query)idQuery, BooleanClause.Occur.MUST);
                    queryBuilder.add((Query)typeQuery, BooleanClause.Occur.MUST);
                    BooleanQuery query = queryBuilder.build();
                    String queryString = query.toString();
                    TopDocs search = searcher.search((Query)query, 10);
                    int found = search.totalHits;
                    if (found > 0) {
                        indexWriter.deleteDocuments(new Query[]{query});
                        logger.debug("deleting " + found + " existing document(s) for query " + queryString);
                    }
                    if (Document.CREATE.equals((Object)event)) {
                        indexWriter.addDocument((Iterable)luceneDocument);
                        logger.debug("creating document " + queryString);
                        ++created;
                    } else if (Document.UPDATE.equals((Object)event)) {
                        indexWriter.addDocument((Iterable)luceneDocument);
                        logger.debug("updating document " + queryString);
                        ++updated;
                    } else if (Document.DELETE.equals((Object)event)) {
                        ++deleted;
                    }
                    long duration = System.currentTimeMillis() - start;
                    logger.debug("[" + duration + "ms] " + event + ", query: " + queryString);
                }
                indexWriter.commit();
                needsRollback = false;
                logger.info("comitted IndexWriter#{}", (Object)indexWriter.hashCode());
                int after = indexWriter.numDocs();
                int overall = created + updated + deleted;
                String mssg = "done with DocumentProducer '{}' which offered {} events (CREATE: {}, UPDATE: {}, DELETE: {}). The index now contains {} documents (was {} before)";
                logger.info(mssg, new Object[]{producer.getName(), overall, created, updated, deleted, after, before});
                logger.debug("comitted IndexWriter#" + indexWriter.hashCode() + ", containing " + after + " documents (before: " + before + ") directory: " + this.indexDir.getAbsolutePath());
                this.close(new Closeable[]{indexWriter, reader, directory});
            }
        }
        catch (IOException ioe) {
            logger.error("an I/O error occured", (Throwable)ioe);
            if (null != indexWriter && needsRollback) {
                try {
                    logger.info("rolling back changes on IndexWriter#{}", (Object)indexWriter.hashCode());
                    indexWriter.rollback();
                    logger.info("rolling back on IndexWriter#{} successfull", (Object)indexWriter.hashCode());
                }
                catch (IOException e) {
                    logger.info("error rolling back changes on IndexWriter#{}", (Object)indexWriter.hashCode());
                }
            }
            this.close(new Closeable[]{indexWriter, reader, directory});
        }
        catch (InterruptedException ie) {
            block27: {
                logger.error("thread was interrupted", (Throwable)ie);
                if (null == indexWriter || !needsRollback) break block27;
                try {
                    logger.info("rolling back changes on IndexWriter#{}", (Object)indexWriter.hashCode());
                    indexWriter.rollback();
                    logger.info("rolling back on IndexWriter#{} successfull", (Object)indexWriter.hashCode());
                }
                catch (IOException e) {
                    logger.info("error rolling back changes on IndexWriter#{}", (Object)indexWriter.hashCode());
                }
            }
            this.close(new Closeable[]{indexWriter, reader, directory});
        }
        catch (Exception e) {
            block28: {
                logger.error("unexpected error", (Throwable)e);
                if (null == indexWriter || !needsRollback) break block28;
                {
                    catch (Throwable throwable) {
                        if (null != indexWriter && needsRollback) {
                            try {
                                logger.info("rolling back changes on IndexWriter#{}", (Object)indexWriter.hashCode());
                                indexWriter.rollback();
                                logger.info("rolling back on IndexWriter#{} successfull", (Object)indexWriter.hashCode());
                            }
                            catch (IOException e2) {
                                logger.info("error rolling back changes on IndexWriter#{}", (Object)indexWriter.hashCode());
                            }
                        }
                        this.close(new Closeable[]{indexWriter, reader, directory});
                        throw throwable;
                    }
                }
                try {
                    logger.info("rolling back changes on IndexWriter#{}", (Object)indexWriter.hashCode());
                    indexWriter.rollback();
                    logger.info("rolling back on IndexWriter#{} successfull", (Object)indexWriter.hashCode());
                }
                catch (IOException e3) {
                    logger.info("error rolling back changes on IndexWriter#{}", (Object)indexWriter.hashCode());
                }
            }
            this.close(new Closeable[]{indexWriter, reader, directory});
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void close(Closeable ... closeables) {
        for (Closeable closeable : closeables) {
            if (null == closeable) continue;
            try {
                closeable.close();
                logger.debug("closed " + closeable);
            }
            catch (IOException e) {
                logger.debug("error closing " + closeable, (Throwable)e);
            }
            finally {
                closeable = null;
            }
        }
    }

    private org.apache.lucene.document.Document getDocument(Document document) {
        org.apache.lucene.document.Document indexDoc = new org.apache.lucene.document.Document();
        this.addStringField(indexDoc, "id", document.getId(), Field.Store.YES);
        this.addTextField(indexDoc, "title", document.getName(), Field.Store.YES);
        this.addStringField(indexDoc, "path", document.getPath(), Field.Store.YES);
        this.addTextField(indexDoc, "teaser", document.getDescription(), Field.Store.YES);
        Date dueDate = document.getDate();
        if (null != dueDate) {
            this.addStringField(indexDoc, "date", DATEFORMAT.format(dueDate), Field.Store.YES);
        }
        this.addTextField(indexDoc, "contents", document.getContent(), Field.Store.YES);
        this.addStringField(indexDoc, "type", document.getType(), Field.Store.YES);
        this.addStringField(indexDoc, "language", document.getLanguage(), Field.Store.YES);
        if (document.getAdditionalFields() != null) {
            for (IndexableField field : document.getAdditionalFields()) {
                indexDoc.add(field);
            }
        }
        return indexDoc;
    }

    private void addTextField(org.apache.lucene.document.Document indexDoc, String name, String value, Field.Store store) {
        if (null != value) {
            indexDoc.add((IndexableField)new TextField(name, value, store));
        }
    }

    private void addStringField(org.apache.lucene.document.Document indexDoc, String name, String value, Field.Store store) {
        if (null != value) {
            indexDoc.add((IndexableField)new StringField(name, value, store));
        }
    }
}

