/*
 * Decompiled with CFR 0.152.
 */
package org.appng.search.json;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.appng.api.model.Named;
import org.appng.search.json.FilterConfig;
import org.appng.search.json.FilterData;

public class FilterItem {
    private FilterConfig config;
    private List<FilterData> data = new ArrayList<FilterData>();

    public FilterConfig getConfig() {
        return this.config;
    }

    public void setConfig(FilterConfig config) {
        this.config = config;
    }

    public List<FilterData> getData() {
        return this.data;
    }

    public void setData(List<FilterData> data) {
        this.data = data;
    }

    public static <ID extends Serializable, T extends Named<ID>> FilterItem getFilterItem(String name, String label, String type, Iterable<T> items, Collection<ID> selectedList, DataCounter counter) {
        FilterItem item = new FilterItem();
        FilterConfig filterConfig = new FilterConfig();
        filterConfig.setLabel(label);
        filterConfig.setName(name);
        filterConfig.setType(type);
        filterConfig.setVisibleItemsCount(counter.getMaxItems());
        item.setConfig(filterConfig);
        int count = 0;
        for (Named named : items) {
            Serializable id = named.getId();
            int itemCount = counter.count(id);
            if (itemCount > 0) {
                FilterData data = new FilterData();
                data.setActive(selectedList.contains(id));
                data.setLabel(named.getName());
                data.setValue(id.toString());
                data.setResultsCount(itemCount);
                item.getData().add(data);
            }
            ++count;
        }
        filterConfig.setItemsCount(count);
        return item;
    }

    public static interface DataCounter {
        public int count(Serializable var1);

        public int getMaxItems();
    }
}

