/*
 * Decompiled with CFR 0.152.
 */
package org.appng.search.json;

import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlTransient;
import javax.xml.bind.annotation.XmlType;
import javax.xml.bind.annotation.XmlValue;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import org.apache.lucene.index.IndexableField;
import org.appng.api.search.Document;
import org.appng.search.searcher.DateAdapter;

@XmlType(propOrder={"title", "link", "date", "score", "type", "language", "image", "fragment", "text", "fields"})
public class Result
implements Comparable<Result> {
    private String title;
    private Date date;
    private String text;
    private String fragment;
    private String type;
    private String language;
    private String image;
    private String link;
    private float score;
    private Fields fields = new Fields();

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    @XmlJavaTypeAdapter(value=DateAdapter.class)
    public Date getDate() {
        return this.date;
    }

    public void setDate(Date date) {
        this.date = date;
    }

    public String getText() {
        return this.text;
    }

    public void setText(String text) {
        this.text = text;
    }

    public String getImage() {
        return this.image;
    }

    public void setImage(String image) {
        this.image = image;
    }

    public String getLink() {
        return this.link;
    }

    public void setLink(String link) {
        this.link = link;
    }

    public String getLanguage() {
        return this.language;
    }

    public void setLanguage(String language) {
        this.language = language;
    }

    public String getFragment() {
        return this.fragment;
    }

    public void setFragment(String fragment) {
        this.fragment = fragment;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public float getScore() {
        return this.score;
    }

    public void setScore(float score) {
        this.score = score;
    }

    @JsonIgnore
    public Fields getFields() {
        return this.fields;
    }

    public void setFields(Fields fields) {
        this.fields = fields;
    }

    public static Result fromDocument(Document d) {
        Result result = new Result();
        result.setDate(d.getDate());
        result.setFragment(d.getFragment());
        result.setImage(d.getImage());
        result.setLanguage(d.getLanguage());
        result.setLink(d.getPath());
        result.setScore(d.getScore());
        result.setText(d.getContent());
        result.setTitle(d.getName());
        result.setType(d.getType());
        result.setFields(new Fields());
        for (IndexableField field : d.getAdditionalFields()) {
            result.getFields().add(new Field(field.name(), field.stringValue()));
        }
        return result;
    }

    @Override
    public int compareTo(Result other) {
        return Float.compare(other.getScore(), this.getScore());
    }

    @XmlTransient
    @JsonGetter(value="fields")
    public List<Field> getFieldList() {
        return this.fields.getFields();
    }

    @XmlType
    public static class Field {
        private String name;
        private String value;

        public Field() {
        }

        public Field(String name, String value) {
            this.name = name;
            this.value = value;
        }

        @XmlAttribute
        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        @XmlValue
        public String getValue() {
            return this.value;
        }

        public void setValue(String value) {
            this.value = value;
        }
    }

    @XmlType
    public static class Fields {
        private List<Field> fields = new ArrayList<Field>();

        @XmlElement(name="field")
        public List<Field> getFields() {
            return this.fields;
        }

        public void add(Field field) {
            this.fields.add(field);
        }

        public void setFields(List<Field> fields) {
            this.fields = fields;
        }
    }
}

