/*
 * Decompiled with CFR 0.152.
 */
package org.appng.search.searcher;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.annotation.adapters.XmlAdapter;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.appng.search.json.FilterConfig;
import org.appng.search.json.FilterData;
import org.appng.search.json.FilterItem;
import org.appng.search.json.Json;
import org.appng.search.json.Page;
import org.appng.search.json.Part;
import org.appng.search.json.Result;
import org.appng.search.json.Results;
import org.appng.search.json.Search;
import org.appng.search.json.SearchFilter;
import org.appng.search.searcher.DateAdapter;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class SearchFormatter {
    public static final int DEFAULT_PAGE = 0;
    public static final String DEFAULT_PAGE_PARAM = "page";
    public static final int DEFAULT_PAGESIZE = 25;
    public static final String DEFAULT_PAGE_SIZE_PARAM = "pageSize";
    public static final String DEFAULT_QUERY_PARAM = "q";
    public static final String DEFAULT_DATE_PATTERN = "yyyy-MM-dd";
    public static final String FORMAT_JSON = "json";
    public static final String FORMAT_XML = "xml";
    private int page = 0;
    private String pageParamName = "page";
    private int pageSize = 25;
    private String pageSizeParamName = "pageSize";
    private String query;
    private String queryParamName = "q";
    private boolean pretty = false;
    private String format = "json";
    private boolean useParts = true;
    private boolean doXsl = true;
    private long time = 0L;
    private String dateFormat = "yyyy-MM-dd";
    private File xslStylesheet = null;
    private static final String XML_COMMENT_OPEN = "<!-- ";
    private static final String XML_COMMENT_CLOSE = "-->";
    private List<Part> parts = new ArrayList<Part>();
    private DocumentBuilderFactory documentBuilderFactory;
    private TransformerFactory transformerFactory;
    private static JAXBContext jaxbContext;

    public SearchFormatter(DocumentBuilderFactory documentBuilderFactory, TransformerFactory transformerFactory) {
        this.documentBuilderFactory = documentBuilderFactory;
        this.transformerFactory = transformerFactory;
    }

    public void write(OutputStream out) throws IOException {
        StringWriter writer = new StringWriter();
        this.write(writer);
        out.write(writer.toString().getBytes("UTF-8"));
    }

    public void write(Writer writer) throws IOException {
        SimpleDateFormat sdf = new SimpleDateFormat(this.dateFormat);
        if (FORMAT_JSON.equalsIgnoreCase(this.format)) {
            Json json = new Json(sdf, this.pretty);
            Object jsonResult = this.useParts ? this.parts : this.paginate(this.getSortedDocs());
            writer.write(json.toJson(jsonResult));
        } else if (FORMAT_XML.equalsIgnoreCase(this.format)) {
            StringWriter tempWriter = new StringWriter();
            this.processXML(tempWriter, this.getSortedDocs(), sdf);
            writer.write(tempWriter.toString());
        } else {
            throw new IOException(String.format("Invalid format: %s", this.format));
        }
    }

    protected List<Result> getSortedDocs() {
        ArrayList<Result> sortedDocs = new ArrayList<Result>();
        for (Part part : this.parts) {
            sortedDocs.addAll(part.getData());
        }
        Collections.sort(sortedDocs);
        return sortedDocs;
    }

    protected void processXML(Writer writer, List<Result> sortedDocs, DateFormat dateFormat) throws IOException {
        Search<SearchFilter> paginate = this.paginate(sortedDocs);
        try {
            Transformer transformer;
            Marshaller marshaller = jaxbContext.createMarshaller();
            marshaller.setAdapter(DateAdapter.class, (XmlAdapter)new DateAdapter(dateFormat));
            Document document = this.documentBuilderFactory.newDocumentBuilder().newDocument();
            marshaller.marshal(paginate, (Node)document);
            if (this.doXsl && null != this.xslStylesheet && this.xslStylesheet.isFile()) {
                transformer = this.transformerFactory.newTemplates(new StreamSource(this.xslStylesheet)).newTransformer();
            } else {
                transformer = this.transformerFactory.newTransformer();
                transformer.setOutputProperty("cdata-section-elements", "title fragment text");
                transformer.setOutputProperty("indent", this.pretty ? "yes" : "no");
            }
            if (!this.doXsl) {
                writer.write(XML_COMMENT_OPEN);
            }
            transformer.transform(new DOMSource(document), new StreamResult(writer));
            if (!this.doXsl) {
                writer.write(XML_COMMENT_CLOSE);
            }
        }
        catch (ParserConfigurationException e) {
            throw new IOException(e);
        }
        catch (TransformerException e) {
            throw new IOException(e);
        }
        catch (JAXBException e) {
            throw new IOException(e);
        }
    }

    protected Search<SearchFilter> paginate(List<Result> sortedDocs) {
        int toIndex;
        Search<SearchFilter> searchResult = new Search<SearchFilter>();
        Results results = new Results();
        results.setTime(this.time);
        searchResult.setResults(results);
        int startIdx = this.page * this.pageSize;
        int numberOfItems = sortedDocs.size();
        if (startIdx > numberOfItems) {
            startIdx = 0;
        }
        if ((toIndex = startIdx + this.pageSize) > numberOfItems) {
            toIndex = numberOfItems;
        }
        List<Result> resultList = sortedDocs.subList(startIdx, toIndex);
        results.getData().addAll(resultList);
        Integer pages = numberOfItems / this.pageSize + (numberOfItems % this.pageSize > 0 ? 1 : 0);
        Page pagination = new Page();
        pagination.setNumberOfElements(sortedDocs.size());
        pagination.setNumberOfPages(pages);
        pagination.setPage(this.page);
        pagination.setPageSize(this.pageSize);
        pagination.setPageParam(this.pageParamName);
        pagination.setPageSizeParam(this.pageSizeParamName);
        searchResult.getResults().setPagination(pagination);
        FilterItem searchFilter = new FilterItem();
        FilterConfig config = new FilterConfig();
        config.setName(this.queryParamName);
        searchFilter.setConfig(config);
        FilterData filterData = new FilterData();
        filterData.setValue(this.query);
        filterData.setActive(true);
        searchFilter.getData().add(filterData);
        SearchFilter filter = new SearchFilter(searchFilter);
        searchResult.setFilter(filter);
        return searchResult;
    }

    public int getPage() {
        return this.page;
    }

    public void setPage(int page) {
        this.page = page;
    }

    public String getPageParamName() {
        return this.pageParamName;
    }

    public void setPageParamName(String pageParamName) {
        this.pageParamName = pageParamName;
    }

    public int getPageSize() {
        return this.pageSize;
    }

    public void setPageSize(int pageSize) {
        this.pageSize = pageSize;
    }

    public String getPageSizeParamName() {
        return this.pageSizeParamName;
    }

    public void setPageSizeParamName(String pageSizeParamName) {
        this.pageSizeParamName = pageSizeParamName;
    }

    public String getQueryParamName() {
        return this.queryParamName;
    }

    public void setQueryParamName(String queryParamName) {
        this.queryParamName = queryParamName;
    }

    public boolean isPretty() {
        return this.pretty;
    }

    public void setPretty(boolean pretty) {
        this.pretty = pretty;
    }

    public String getFormat() {
        return this.format;
    }

    public void setFormat(String format) {
        this.format = format;
    }

    public boolean isUseParts() {
        return this.useParts;
    }

    public void setUseParts(boolean useParts) {
        this.useParts = useParts;
    }

    public String getDateFormat() {
        return this.dateFormat;
    }

    public void setDateFormat(String dateFormat) {
        this.dateFormat = dateFormat;
    }

    public List<Part> getParts() {
        return this.parts;
    }

    public void setParts(List<Part> parts) {
        this.parts = parts;
    }

    public String getQueryParam() {
        return this.query;
    }

    public void setQueryParam(String queryParam) {
        this.query = queryParam;
    }

    public File getXslStylesheet() {
        return this.xslStylesheet;
    }

    public void setXslStylesheet(File xslStylesheet) {
        this.xslStylesheet = xslStylesheet;
    }

    public long getTime() {
        return this.time;
    }

    public void setTime(long time) {
        this.time = time;
    }

    public boolean isDoXsl() {
        return this.doXsl;
    }

    public void setDoXsl(boolean doXsl) {
        this.doXsl = doXsl;
    }

    static {
        try {
            jaxbContext = JAXBContext.newInstance((String)"org.appng.search.json");
        }
        catch (JAXBException e) {
            throw new IllegalStateException(e);
        }
    }
}

