/*
 * Decompiled with CFR 0.152.
 */
package org.appng.search.json;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectReader;
import com.fasterxml.jackson.databind.ObjectWriter;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.text.DateFormat;
import java.text.SimpleDateFormat;

public class Json {
    private boolean pretty = false;
    private ObjectMapper mapper;

    public Json(DateFormat dateFormat, boolean pretty) {
        this.pretty = pretty;
        this.mapper = new ObjectMapper();
        this.mapper.setDateFormat(dateFormat);
    }

    public Json() {
        this(new SimpleDateFormat(), false);
    }

    public String toJson(Object o, JsonInclude.Include include) throws JsonProcessingException, IOException {
        ObjectMapper innerMapper = this.mapper.setSerializationInclusion(include);
        ObjectWriter writer = innerMapper.writer();
        if (this.pretty) {
            writer = writer.withDefaultPrettyPrinter();
        }
        StringWriter stringWriter = new StringWriter();
        writer.writeValue((Writer)stringWriter, o);
        return stringWriter.toString();
    }

    public String toJson(Object o) throws JsonProcessingException, IOException {
        return this.toJson(o, JsonInclude.Include.NON_NULL);
    }

    public <T> T toObject(String json, Class<T> type, Module ... modules) throws IOException {
        for (Module module : modules) {
            this.mapper.registerModule(module);
        }
        ObjectReader reader = this.mapper.readerFor(type);
        return (T)reader.readValue(json);
    }
}

