/*
 * Decompiled with CFR 0.152.
 */
package org.appng.search.searcher;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.de.GermanAnalyzer;
import org.apache.lucene.analysis.tokenattributes.CharTermAttribute;
import org.appng.search.searcher.SearchTermProcessor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GermanSearchTermProcessor
implements SearchTermProcessor {
    private static Logger log = LoggerFactory.getLogger(GermanSearchTermProcessor.class);
    private static String[] charsToRemove = new String[]{"!", "?", ".", ",", "<", ">", "{", "}", "[", "]", "+", "-", "*", "/", "\\", "&", "|", "=", "%", "$", "\u00a7", "#"};
    private GermanAnalyzer analyzer = new GermanAnalyzer();
    private Map<String, String> searchTerms;

    public GermanSearchTermProcessor() {
        this(new HashMap<String, String>());
    }

    public GermanSearchTermProcessor(Map<String, String> searchTerms) {
        this.searchTerms = searchTerms;
    }

    @Override
    public String getSearchTerm(String searchWord) {
        searchWord = this.cleanSearchWord(searchWord);
        StringTokenizer tokenizer = new StringTokenizer(searchWord);
        StringBuilder searchTerm = new StringBuilder();
        int count = 0;
        try {
            while (tokenizer.hasMoreTokens()) {
                String token = tokenizer.nextToken();
                this.append(searchTerm, count, " AND ");
                if (null != this.searchTerms && this.searchTerms.containsKey(token)) {
                    this.append(searchTerm, count, "(");
                    searchTerm.append(this.searchTerms.get(token));
                    this.append(searchTerm, count, ")");
                } else {
                    TokenStream tokenStream = this.analyzer.tokenStream(null, (Reader)new StringReader(token));
                    tokenStream.reset();
                    while (tokenStream.incrementToken()) {
                        String stemmedSearchWord = ((CharTermAttribute)tokenStream.getAttribute(CharTermAttribute.class)).toString();
                        if (!"".equals(stemmedSearchWord)) {
                            if (this.hasUmlaut(token)) {
                                searchTerm.append("(*" + stemmedSearchWord + " OR " + this.removeUmlauts(token) + "*)");
                                continue;
                            }
                            searchTerm.append("(*" + stemmedSearchWord + " OR " + stemmedSearchWord + "*)");
                            continue;
                        }
                        searchTerm.append(searchWord);
                    }
                    tokenStream.end();
                    tokenStream.close();
                }
                ++count;
            }
        }
        catch (IOException e) {
            log.error("error assembling searchterm", (Throwable)e);
        }
        return searchTerm.toString();
    }

    private void append(StringBuilder searchTerm, int count, String string) {
        if (0 != count) {
            searchTerm.append(string);
        }
    }

    public String removeUmlauts(String term) {
        term = term.replace("\u00e4", "a");
        term = term.replace("\u00f6", "o");
        term = term.replace("\u00fc", "u");
        term = term.replace("\u00df", "ss");
        return term;
    }

    public String cleanSearchWord(String term) {
        for (String replacment : charsToRemove) {
            term = term.replace(replacment, "");
        }
        return term.toLowerCase();
    }

    private boolean hasUmlaut(String searchWord) {
        return searchWord.indexOf("\u00e4") > -1 || searchWord.indexOf("\u00f6") > -1 || searchWord.indexOf("\u00fc") > -1 || searchWord.indexOf("\u00df") > -1;
    }

    @Override
    public Analyzer getAnalyzer() {
        return this.analyzer;
    }
}

