/*
 * Decompiled with CFR 0.152.
 */
package org.appng.application.scheduler.service;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.time.LocalDate;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.appng.api.ScheduledJobResult;
import org.appng.api.model.Application;
import org.appng.api.model.Site;
import org.appng.application.scheduler.model.JobRecord;
import org.appng.application.scheduler.model.JobResult;
import org.quartz.JobDataMap;
import org.quartz.JobExecutionException;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.core.namedparam.MapSqlParameterSource;
import org.springframework.jdbc.core.namedparam.NamedParameterJdbcTemplate;
import org.springframework.jdbc.core.namedparam.SqlParameterSource;
import org.springframework.stereotype.Component;

@Component
public class JobRecordService {
    private static final String FIELD_ID = "id";
    private static final String FIELD_TRIGGERNAME = "triggername";
    private static final String FIELD_CUSTOM_DATA = "custom_data";
    private static final String FIELD_STACKTRACES = "stacktraces";
    private static final String FIELD_RESULT = "result";
    private static final String FIELD_RUN_ONCE = "run_once";
    private static final String FIELD_DURATION = "duration";
    private static final String FIELD_END = "end_time";
    private static final String FIELD_START = "start_time";
    private static final String FIELD_JOB_NAME = "job_name";
    private static final String FIELD_SITE = "site";
    private static final String FIELD_APPLICATION = "application";
    private static final String PARAM_OUTDATED = "outdated";
    private static final String TABLE_NAME = "job_execution_record";
    private static final String QUERY_INSERT = String.format("INSERT INTO %s (%s,%s,%s,%s,%s,%s,%s,%s,%s,%s,%s) VALUES (:%s,:%s,:%s,:%s,:%s,:%s,:%s,:%s,:%s,:%s,:%s)", "job_execution_record", "application", "site", "job_name", "start_time", "end_time", "duration", "run_once", "result", "stacktraces", "custom_data", "triggername", "application", "site", "job_name", "start_time", "end_time", "duration", "run_once", "result", "stacktraces", "custom_data", "triggername");
    private static final String QUERY_SELECT = String.format("SELECT * FROM %s", "job_execution_record");
    private static final String QUERY_SELECT_BY_ID_AND_SITE = String.format("%s WHERE %s = :%s AND %s= :%s", QUERY_SELECT, "site", "site", "id", "id");
    private static final String QUERY_DELETE_OUTDATED = String.format("DELETE FROM %s WHERE %s = :%s AND %s < :%s;", "job_execution_record", "site", "site", "start_time", "outdated");
    private static final String QUERY_COUNT_OUTDATED = String.format("SELECT count(*) FROM %s WHERE %s = :%s AND %s < :%s ;", "job_execution_record", "site", "site", "start_time", "outdated");
    private NamedParameterJdbcTemplate jdbcTemplate;

    public JobRecordService(NamedParameterJdbcTemplate jdbcTemplate) {
        this.jdbcTemplate = jdbcTemplate;
    }

    public void recordJob(JobResult jobResult, Date fireTime, Date endTime, long jobRunTime, JobDataMap jobDataMap, JobExecutionException jobException, String triggerName) {
        String result = this.getResult(jobResult, jobException);
        MapSqlParameterSource paramsMap = new MapSqlParameterSource();
        paramsMap.addValue(FIELD_APPLICATION, (Object)jobResult.getApplicationName());
        paramsMap.addValue(FIELD_SITE, (Object)jobResult.getSiteName());
        paramsMap.addValue(FIELD_JOB_NAME, (Object)jobResult.getJobName());
        paramsMap.addValue(FIELD_START, (Object)fireTime);
        paramsMap.addValue(FIELD_END, (Object)endTime);
        paramsMap.addValue(FIELD_DURATION, (Object)(jobRunTime / 1000L));
        paramsMap.addValue(FIELD_RUN_ONCE, (Object)jobDataMap.getBoolean("runOnce"));
        paramsMap.addValue(FIELD_RESULT, (Object)result);
        paramsMap.addValue(FIELD_STACKTRACES, (Object)(null == jobException ? null : ExceptionUtils.getStackTrace((Throwable)jobException)));
        paramsMap.addValue(FIELD_CUSTOM_DATA, (Object)jobResult.getCustomData());
        paramsMap.addValue(FIELD_TRIGGERNAME, (Object)triggerName);
        this.jdbcTemplate.update(QUERY_INSERT, (SqlParameterSource)paramsMap);
    }

    private String getResult(JobResult jobResult, JobExecutionException jobException) {
        if (null != jobResult.getResult()) {
            return jobResult.getResult().toString();
        }
        if (null == jobException) {
            return ScheduledJobResult.ExecutionResult.SUCCESS.toString();
        }
        return ScheduledJobResult.ExecutionResult.FAIL.toString();
    }

    public List<String> getDistinctElements(String siteName, final String fieldName) {
        MapSqlParameterSource paramsMap = new MapSqlParameterSource();
        paramsMap.addValue(FIELD_SITE, (Object)siteName);
        String query = String.format("SELECT DISTINCT %s FROM %s WHERE %s = :%s ORDER BY %s DESC", fieldName, TABLE_NAME, FIELD_SITE, FIELD_SITE, fieldName);
        return this.jdbcTemplate.query(query, (SqlParameterSource)paramsMap, (RowMapper)new RowMapper<String>(){

            public String mapRow(ResultSet rs, int rowNum) throws SQLException {
                return rs.getString(fieldName);
            }
        });
    }

    public List<JobRecord> getRecords(String siteName, String applicationFilter, String jobFilter, String start, String end, String result, String duration) {
        MapSqlParameterSource paramsMap = new MapSqlParameterSource();
        StringBuilder sql = new StringBuilder(QUERY_SELECT);
        boolean first = true;
        first = this.addFilter(FIELD_SITE, "=", siteName, sql, paramsMap, first);
        first = this.addFilter(FIELD_APPLICATION, "=", applicationFilter, sql, paramsMap, first);
        first = this.addFilter(FIELD_JOB_NAME, "=", jobFilter, sql, paramsMap, first);
        first = this.addFilter(FIELD_RESULT, "=", result, sql, paramsMap, first);
        first = this.addFilter(FIELD_START, ">", start, sql, paramsMap, first);
        first = this.addFiler(FIELD_START, "<", end, sql, paramsMap, first, FIELD_END);
        this.addFilter(FIELD_DURATION, ">=", duration, sql, paramsMap, first);
        sql.append(" ORDER BY start_time DESC;");
        return this.jdbcTemplate.query(sql.toString(), (SqlParameterSource)paramsMap, (RowMapper)new RecordRowMapper());
    }

    private boolean addFilter(String filterName, String operator, String filterValue, StringBuilder sql, MapSqlParameterSource paramsMap, boolean first) {
        return this.addFiler(filterName, operator, filterValue, sql, paramsMap, first, filterName);
    }

    private boolean addFiler(String filterName, String operator, String filterValue, StringBuilder sql, MapSqlParameterSource paramsMap, boolean first, String paramName) {
        if (StringUtils.isNotBlank((CharSequence)filterValue)) {
            sql.append(first ? " WHERE " : " AND ");
            sql.append(filterName);
            sql.append(" ");
            sql.append(operator);
            sql.append(" :");
            sql.append(paramName);
            paramsMap.addValue(paramName, (Object)filterValue);
            return false;
        }
        return first;
    }

    public String cleanUp(Site site, Application application) {
        if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{application.getProperties().getString("recordLifeTime")})) {
            Integer lifetime = application.getProperties().getInteger("recordLifeTime");
            MapSqlParameterSource paramsMap = new MapSqlParameterSource();
            LocalDate outdated = LocalDate.now().minusDays(lifetime.intValue());
            paramsMap.addValue(PARAM_OUTDATED, (Object)outdated);
            paramsMap.addValue(FIELD_SITE, (Object)site.getName());
            Long count = (Long)this.jdbcTemplate.queryForObject(QUERY_COUNT_OUTDATED, (SqlParameterSource)paramsMap, Long.class);
            if (count > 0L) {
                this.jdbcTemplate.update(QUERY_DELETE_OUTDATED, (SqlParameterSource)paramsMap);
            }
            return count.toString();
        }
        return null;
    }

    public JobRecord getRecord(String siteName, String recordId) {
        MapSqlParameterSource paramsMap = new MapSqlParameterSource();
        paramsMap.addValue(FIELD_SITE, (Object)siteName);
        paramsMap.addValue(FIELD_ID, (Object)recordId);
        JobRecord res = (JobRecord)this.jdbcTemplate.queryForObject(QUERY_SELECT_BY_ID_AND_SITE, (SqlParameterSource)paramsMap, (RowMapper)new RecordRowMapper());
        return res;
    }

    private class RecordRowMapper
    implements RowMapper<JobRecord> {
        private RecordRowMapper() {
        }

        public JobRecord mapRow(ResultSet rs, int rowNum) throws SQLException {
            JobRecord record = new JobRecord();
            record.setId(rs.getInt(JobRecordService.FIELD_ID));
            record.setSiteName(rs.getString(JobRecordService.FIELD_SITE));
            record.setJobName(rs.getString(JobRecordService.FIELD_JOB_NAME));
            record.setApplicationName(rs.getString(JobRecordService.FIELD_APPLICATION));
            record.setStart(rs.getTimestamp(JobRecordService.FIELD_START));
            record.setEnd(rs.getTimestamp(JobRecordService.FIELD_END));
            record.setDuration(rs.getLong(JobRecordService.FIELD_DURATION));
            record.setRunOnce(rs.getBoolean(JobRecordService.FIELD_RUN_ONCE));
            record.setScheduledJobResult(new ScheduledJobResult());
            record.getScheduledJobResult().setResult(ScheduledJobResult.ExecutionResult.valueOf((String)rs.getString(JobRecordService.FIELD_RESULT)));
            record.getScheduledJobResult().setCustomData(rs.getString(JobRecordService.FIELD_CUSTOM_DATA));
            record.setStacktraces(rs.getString(JobRecordService.FIELD_STACKTRACES));
            record.setTriggerName(rs.getString(JobRecordService.FIELD_TRIGGERNAME));
            return record;
        }
    }
}

