/*
 * Decompiled with CFR 0.152.
 */
package org.appng.application.scheduler.quartz;

import java.util.Date;
import org.appng.application.scheduler.model.JobResult;
import org.appng.application.scheduler.service.JobRecordService;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;
import org.quartz.JobListener;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component
public class RecordingJobListener
implements JobListener {
    private JobRecordService jobRecordService;
    @Value(value="${enableJobRecord:true}")
    private boolean enabled;

    public RecordingJobListener(JobRecordService jobRecordService) {
        this.jobRecordService = jobRecordService;
    }

    public String getName() {
        return this.getClass().getName();
    }

    public void jobToBeExecuted(JobExecutionContext context) {
    }

    public void jobExecutionVetoed(JobExecutionContext context) {
    }

    public void jobWasExecuted(JobExecutionContext context, JobExecutionException jobException) {
        Object result;
        if (this.enabled && (result = context.getResult()) instanceof JobResult) {
            this.jobRecordService.recordJob((JobResult)result, context.getFireTime(), new Date(), context.getJobRunTime(), context.getJobDetail().getJobDataMap(), jobException, context.getTrigger().getKey().getName());
        }
    }
}

