/*
 * Decompiled with CFR 0.152.
 */
package org.appng.application.scheduler.job;

import java.util.Map;
import org.appng.api.ScheduledJob;
import org.appng.api.model.Application;
import org.appng.api.model.Site;
import org.appng.api.search.Consumer;
import org.appng.search.indexer.GlobalIndexer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IndexJob
implements ScheduledJob {
    private static final Logger LOG = LoggerFactory.getLogger(IndexJob.class);
    private Map<String, Object> jobDataMap;
    private String description;

    public void execute(Site site, Application application) throws Exception {
        LOG.debug("started IndexJob ({}) for site {}", (Object)this.description, (Object)site.getName());
        Consumer indexer = application.getFeatureProvider().getIndexer();
        String jspFileType = (String)this.getJobDataMap().get("jspFileType");
        new GlobalIndexer(indexer).doIndex(site, jspFileType);
        LOG.debug("finished IndexJob ({}) for site {}", (Object)this.description, (Object)site.getName());
    }

    public Map<String, Object> getJobDataMap() {
        return this.jobDataMap;
    }

    public String getDescription() {
        return this.description;
    }

    public void setJobDataMap(Map<String, Object> jobDataMap) {
        this.jobDataMap = jobDataMap;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof IndexJob)) {
            return false;
        }
        IndexJob other = (IndexJob)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Map<String, Object> this$jobDataMap = this.getJobDataMap();
        Map<String, Object> other$jobDataMap = other.getJobDataMap();
        if (this$jobDataMap == null ? other$jobDataMap != null : !((Object)this$jobDataMap).equals(other$jobDataMap)) {
            return false;
        }
        String this$description = this.getDescription();
        String other$description = other.getDescription();
        return !(this$description == null ? other$description != null : !this$description.equals(other$description));
    }

    protected boolean canEqual(Object other) {
        return other instanceof IndexJob;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Map<String, Object> $jobDataMap = this.getJobDataMap();
        result = result * 59 + ($jobDataMap == null ? 43 : ((Object)$jobDataMap).hashCode());
        String $description = this.getDescription();
        result = result * 59 + ($description == null ? 43 : $description.hashCode());
        return result;
    }

    public String toString() {
        return "IndexJob(jobDataMap=" + this.getJobDataMap() + ", description=" + this.getDescription() + ")";
    }
}

